<?php

/**
 * Neo Billing -  Accounting,  Invoicing  and CRM Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */

defined('BASEPATH') or exit('No direct script access allowed');
require_once FCPATH . 'application/third_party/vendor/autoload.php';
require_once FCPATH . 'application/third_party/payapal_c/vendor/autoload.php';

use Omnipay\Omnipay;
use PayPal\Api\Amount;
use PayPal\Api\Payer;
use PayPal\Api\Payment;
use PayPal\Api\RedirectUrls;
use PayPal\Api\Transaction;
use PayPal\Api\PaymentExecution;

class Billing extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('invoices_model', 'invocies');
        $this->load->model('billing_model', 'billing');
        $this->load->library("Aauth");
        $this->load->library('Jdf');
        $this->load->library('Zarinpal');
    }

    public function view()
    {
        $tid = intval($this->input->get('id'));
        $token = $this->input->get('token');
        $validtoken = hash_hmac('ripemd160', $tid, $this->config->item('encryption_key'));
        if (hash_equals($token, $validtoken)) {
            $this->load->model('accounts_model');
            $data['acclist'] = $this->accounts_model->accountslist();
            $tid = intval($this->input->get('id'));
            $data['id'] = $tid;
            $data['token'] = $token;
            $head['title'] = "Invoice $tid";
            $data['invoice'] = $this->invocies->invoice_details($tid);
            $data['online_pay'] = $this->billing->online_pay_settings();
            $data['products'] = $this->invocies->invoice_products($tid);
            $data['activity'] = $this->invocies->invoice_transactions($tid);
            $data['attach'] = $this->invocies->attach($tid);
            $data['employee'] = $this->invocies->employee($data['invoice']['eid']);
            $data['gateway'] = $this->billing->gateway_list('Yes');
            $head['usernm'] = '';

            $this->load->view('billing/header', $head);
            $this->load->view('billing/view', $data);
            $this->load->view('billing/footer');
        }
        if (!$this->input->get()) {
            exit();
        }
    }

    public function invoice()
    {
        if (!$this->input->get()) {
            exit();
        }
        $tid = intval($this->input->get('id'));
        $token = $this->input->get('token');
        $validtoken = hash_hmac('ripemd160', 'rec' . $tid, $this->config->item('encryption_key'));
        if (hash_equals($token, $validtoken)) {
            $this->load->model('rec_invoices_model', 'rec_invocies');
            $this->load->model('accounts_model');
            $data['acclist'] = $this->accounts_model->accountslist();
            $tid = intval($this->input->get('id'));
            $data['id'] = $tid;
            $data['token'] = $token;
            $head['title'] = "Invoice $tid";
            $data['attach'] = $this->rec_invocies->attach($tid);
            $data['invoice'] = $this->rec_invocies->invoice_details($tid);
            $data['online_pay'] = $this->billing->online_pay_settings();
            $data['products'] = $this->rec_invocies->invoice_products($tid);
            $data['activity'] = $this->rec_invocies->invoice_transactions($tid);
            $data['employee'] = $this->invocies->employee($data['invoice']['eid']);
            $data['gateway'] = $this->billing->gateway_list('Yes');
            $head['usernm'] = '';
            $this->load->view('billing/header', $head);
            $this->load->view('billing/reccur', $data);
            $this->load->view('billing/footer');
        }
    }


    public function quoteview()
    {
        if (!$this->input->get()) {
            exit();
        }
        $tid = intval($this->input->get('id'));
        $token = $this->input->get('token');

        $validtoken = hash_hmac('ripemd160', 'q' . $tid, $this->config->item('encryption_key'));

        if (hash_equals($token, $validtoken)) {

            $this->load->model('quote_model', 'quote');

            $this->load->model('accounts_model');
            $data['acclist'] = $this->accounts_model->accountslist();
            $tid = intval($this->input->get('id'));
            $data['id'] = $tid;
            $data['token'] = $token;
            $head['title'] = "Quote $tid";
            $data['invoice'] = $this->quote->quote_details($tid);
            $data['attach'] = $this->quote->attach($tid);
            $data['products'] = $this->quote->quote_products($tid);
            $data['employee'] = $this->quote->employee($data['invoice']['eid']);
            $head['usernm'] = '';
            $this->load->view('billing/header', $head);
            $this->load->view('billing/quoteview', $data);
            $this->load->view('billing/footer');
        }
    }

    public function purchase()
    {
        if (!$this->input->get()) {
            exit();
        }
        $tid = intval($this->input->get('id'));
        $token = $this->input->get('token');

        $validtoken = hash_hmac('ripemd160', 'p' . $tid, $this->config->item('encryption_key'));

        if (hash_equals($token, $validtoken)) {
            $this->load->model('purchase_model', 'purchase');

            $this->load->model('accounts_model');
            $data['acclist'] = $this->accounts_model->accountslist();
            $data['attach'] = $this->purchase->attach($tid);
            $tid = intval($this->input->get('id'));
            $data['id'] = $tid;
            $data['token'] = $token;
            $head['title'] = "Purchase $tid";
            $data['invoice'] = $this->purchase->purchase_details($tid);
            // $data['online_pay'] = $this->purchase->online_pay_settings();
            $data['products'] = $this->purchase->purchase_products($tid);
            $data['activity'] = $this->purchase->purchase_transactions($tid);;


            $data['employee'] = $this->purchase->employee($data['invoice']['eid']);

            $head['usernm'] = '';
            $this->load->view('billing/header', $head);
            $this->load->view('billing/purchase', $data);
            $this->load->view('billing/footer');
        }
    }


    public function stockreturn()
    {
        if (!$this->input->get()) {
            exit();
        }
        $tid = intval($this->input->get('id'));
        $token = $this->input->get('token');

        $validtoken = hash_hmac('ripemd160', 's' . $tid, $this->config->item('encryption_key'));

        if (hash_equals($token, $validtoken)) {
            $this->load->model('stockreturn_model', 'stockreturn');

            $this->load->model('accounts_model');
            $data['acclist'] = $this->accounts_model->accountslist();
            $data['attach'] = $this->stockreturn->attach($tid);
            $tid = intval($this->input->get('id'));
            $data['id'] = $tid;
            $data['token'] = $token;
            $head['title'] = "Stock return $tid";
            $data['invoice'] = $this->stockreturn->purchase_details($tid);
            // $data['online_pay'] = $this->purchase->online_pay_settings();
            $data['products'] = $this->stockreturn->purchase_products($tid);
            $data['activity'] = $this->stockreturn->purchase_transactions($tid);;


            $data['employee'] = $this->stockreturn->employee($data['invoice']['eid']);

            $head['usernm'] = '';
            $this->load->view('billing/header', $head);
            $this->load->view('billing/stockreturn', $data);
            $this->load->view('billing/footer');
        }
    }


    public function gateway()
    {
        if (!$this->input->get()) {
            exit();
        }
        $tid = intval($this->input->post('tid'));
        $token = $this->input->post('token');
        $amount = $this->input->post('p_amount');
        $pay_gateway = $this->input->post('pay_gateway');

        $validtoken = hash_hmac('ripemd160', $tid, $this->config->item('encryption_key'));

        if (hash_equals($token, $validtoken)) {


            switch ($pay_gateway) {

                case 1:
                    $this->card();
                    break;
            }
        }
    }


    public function printinvoice()
    {
        if (!$this->input->get()) {
            exit();
        }
        $tid = intval($this->input->get('id'));
        $token = $this->input->get('token');

        $validtoken = hash_hmac('ripemd160', $tid, $this->config->item('encryption_key'));

        if (hash_equals($token, $validtoken)) {

            $data['id'] = $tid;
            $data['title'] = "Invoice $tid";
            $data['invoice'] = $this->invocies->invoice_details($tid);
            $data['products'] = $this->invocies->invoice_products($tid);
            $data['employee'] = $this->invocies->employee($data['invoice']['eid']);

            ini_set('memory_limit', '-1');
            $html = $this->load->view('invoices/view-print-' . LTR, $data, true);
            $html2 = $this->load->view('invoices/header-print-' . LTR, $data, true);


            //PDF Rendering
            $this->load->library('pdf_invoice');

            $pdf = $this->pdf_invoice->load();
            $pdf->SetHTMLHeader($html2);
            $pdf->SetHTMLFooter('<div style="text-align: right;font-family: vazir; font-size: 8pt; color: #5C5C5C; font-style: italic;margin-top:-6pt;">{PAGENO}/{nbpg} #' . $tid . '</div>');

            $pdf->WriteHTML($html);

            if ($this->input->get('d')) {

                $pdf->Output('Invoice_#' . $tid . '.pdf', 'D');
            } else {
                $pdf->Output('Invoice_#' . $tid . '.pdf', 'I');
            }
        }
    }

    public function print_rec()
    {
        if (!$this->input->get()) {
            exit();
        }
        $tid = intval($this->input->get('id'));
        $token = $this->input->get('token');

        $validtoken = hash_hmac('ripemd160', 'rec' . $tid, $this->config->item('encryption_key'));

        if (hash_equals($token, $validtoken)) {

            $this->load->model('rec_invoices_model', 'rec_invoices');

            $data['id'] = $tid;
            $data['title'] = "Invoice $tid";
            $data['invoice'] = $this->rec_invoices->invoice_details($tid);
            $data['products'] = $this->rec_invoices->invoice_products($tid);
            $data['employee'] = $this->rec_invoices->employee($data['invoice']['eid']);

            ini_set('memory_limit', '-1');

            $html = $this->load->view('rec_invoices/view-print-' . LTR, $data, true);

            //PDF Rendering
            $this->load->library('pdf');

            $pdf = $this->pdf->load();

            $pdf->SetHTMLFooter('<div style="text-align: right;font-family: serif; font-size: 8pt; color: #5C5C5C; font-style: italic;margin-top:-6pt;">{PAGENO}/{nbpg} #' . $tid . '</div>');

            $pdf->WriteHTML($html);

            if ($this->input->get('d')) {

                $pdf->Output('Rec_invoices_#' . $tid . '.pdf', 'D');
            } else {
                $pdf->Output('Rec_invoices_#' . $tid . '.pdf', 'I');
            }
        }
    }

    public function printquote()
    {
        if (!$this->input->get()) {
            exit();
        }
        $tid = intval($this->input->get('id'));
        $token = $this->input->get('token');

        $validtoken = hash_hmac('ripemd160', 'q' . $tid, $this->config->item('encryption_key'));

        if (hash_equals($token, $validtoken)) {

            $this->load->model('quote_model', 'quote');

            $data['id'] = $tid;
            $data['title'] = "Quote $tid";
            $data['invoice'] = $this->quote->quote_details($tid);
            $data['products'] = $this->quote->quote_products($tid);
            $data['employee'] = $this->quote->employee($data['invoice']['eid']);

            ini_set('memory_limit', '-1');

            $html = $this->load->view('quotes/view-print-' . LTR, $data, true);

            //PDF Rendering
            $this->load->library('pdf');

            $pdf = $this->pdf->load();

            $pdf->SetHTMLFooter('<div style="text-align: right;font-family: serif; font-size: 8pt; color: #5C5C5C; font-style: italic;margin-top:-6pt;">{PAGENO}/{nbpg} #' . $tid . '</div>');

            $pdf->WriteHTML($html);

            if ($this->input->get('d')) {

                $pdf->Output('Quote_#' . $tid . '.pdf', 'D');
            } else {
                $pdf->Output('Quote_#' . $tid . '.pdf', 'I');
            }
        }
    }


    public function printorder()
    {
        if (!$this->input->get()) {
            exit();
        }
        $tid = intval($this->input->get('id'));
        $token = $this->input->get('token');

        $validtoken = hash_hmac('ripemd160', 'p' . $tid, $this->config->item('encryption_key'));

        if (hash_equals($token, $validtoken)) {
            $this->load->model('purchase_model', 'purchase');

            $data['id'] = $tid;
            $data['title'] = "Invoice $tid";
            $data['invoice'] = $this->purchase->purchase_details($tid);
            $data['invoice']['multi'] = 0;
            $data['products'] = $this->purchase->purchase_products($tid);
            $data['employee'] = $this->purchase->employee($data['invoice']['eid']);

            ini_set('memory_limit', '-1');

            $html = $this->load->view('purchase/view-print-' . LTR, $data, true);

            //PDF Rendering
            $this->load->library('pdf');

            $pdf = $this->pdf->load();

            $pdf->SetHTMLFooter('<div style="text-align: right;font-family: serif; font-size: 8pt; color: #5C5C5C; font-style: italic;margin-top:-6pt;">{PAGENO}/{nbpg} #' . $tid . '</div>');

            $pdf->WriteHTML($html);

            if ($this->input->get('d')) {

                $pdf->Output('Purchase_order#' . $tid . '.pdf', 'D');
            } else {
                $pdf->Output('Purchase_order#' . $tid . '.pdf', 'I');
            }
        }
    }

    public function printstockreturn()
    {
        if (!$this->input->get()) {
            exit();
        }
        $tid = intval($this->input->get('id'));
        $token = $this->input->get('token');

        $validtoken = hash_hmac('ripemd160', 's' . $tid, $this->config->item('encryption_key'));

        if (hash_equals($token, $validtoken)) {
            $this->load->model('stockreturn_model', 'stockreturn');

            $data['id'] = $tid;
            $data['title'] = "Invoice $tid";
            $data['invoice'] = $this->stockreturn->purchase_details($tid);
            $data['products'] = $this->stockreturn->purchase_products($tid);
            $data['employee'] = $this->stockreturn->employee($data['invoice']['eid']);

            ini_set('memory_limit', '-1');

            $html = $this->load->view('stockreturn/view-print', $data, true);

            //PDF Rendering
            $this->load->library('pdf');

            $pdf = $this->pdf->load();

            $pdf->SetHTMLFooter('<div style="text-align: right;font-family: serif; font-size: 8pt; color: #5C5C5C; font-style: italic;margin-top:-6pt;">{PAGENO}/{nbpg} #' . $tid . '</div>');

            $pdf->WriteHTML($html);

            if ($this->input->get('d')) {

                $pdf->Output('Stockreturn_order#' . $tid . '.pdf', 'D');
            } else {
                $pdf->Output('Stockreturn_order#' . $tid . '.pdf', 'I');
            }
        }
    }

    // zarinpal codes card
    public function card()
    {
        if (!$this->input->get()) {
            exit();
        }
        $this->load->helper('form');
        $online_pay = $this->billing->online_pay_settings();
        if ($online_pay['enable'] == 0) {
            exit();
        }
        $data['tid'] = $this->input->get('id');
        $data['token'] = $this->input->get('token');
        $data['itype'] = $this->input->get('itype');
        $data['gid'] = $this->input->get('gid');
        if ($data['itype'] == 'inv') {
            $validtoken = hash_hmac('ripemd160', $data['tid'], $this->config->item('encryption_key'));
            if (hash_equals($data['token'], $validtoken)) {
                $data['invoice'] = $this->invocies->invoice_details($data['tid']);
            } else {
                exit();
            }
            $data['view_st'] = 'view';
        } else if ($data['itype'] == 'rinv') {
            $validtoken = hash_hmac('ripemd160', 'rec' . $data['tid'], $this->config->item('encryption_key'));
            if (hash_equals($data['token'], $validtoken)) {
                $this->load->model('rec_invoices_model', 'rec_invoices');
                $data['invoice'] = $this->rec_invoices->invoice_details($data['tid']);
            } else {
                exit();
            }
            $data['view_st'] = 'invoice';
        }
        $data['inv_url'] = base_url('billing/view?id=' . $data['tid'] . '&token=' .  $data['token']);
        $online_pay = $this->billing->online_pay_settings();
        /*zarinpal data*/
        $data['gateway'] = $this->billing->gateway($data['gid']);
        if ($online_pay['enable'] == 1) {
            // merchant id get
            $merchant_id = $data['gateway']['key1'];
            // subtraction Amount
            $subtotal_pay = $data['invoice']['subtotal'];
            $pay_amount = $data['invoice']['pamnt'];

            $rming = $subtotal_pay - $pay_amount;
            if ($rming < 0) {
                $rming = 0;
            }
            $currency = $data['gateway']['currency'];
            if ($currency == 'toman') {
                $factor = '10';
            } else {
                $factor = '1';
            }
            $amount = amountExchange_pay(number_format($rming, 0, '.', ''), $data['invoice']['multi']) * $factor;
            //end subtraction Amount
            if ($data['view_st'] == 'invoice') {
                $recurring = $this->lang->line('Recurring');
            } else {
                $recurring = '';
            }
            $desc = $this->lang->line('Invoice Number') .  $recurring . $data['tid'];
            if ($data['view_st'] == 'view') {
                $call =   '/?id=' . $data['tid'] . '&';
            } else {
                $call =  '?id=' . $data['tid'] . '&';
            }
            switch ($data['gid']) {
                case 1:
                    $fname = 'zarinpal';
                    if ($data['view_st'] == 'view') {
                        $type = 'calback';
                    } else {
                        $type = 'calback_invoice';
                    }
                    $token = 'token=';
                    $call_back = base_url('billing/' . $type .  $call . $token . '' .  $data['token']);
                    $data_zarinpal = $this->zarinpal->data($merchant_id, $amount, $desc, $call_back);
                    $error = $this->zarinpal->check($data_zarinpal);
                    break;
                case 2:
                    $fname = 'pay';
                    if ($data['view_st'] == 'view') {
                        $type = 'calbackpay';
                    } else {
                        $type = 'calback_invoice_pay';
                    }
                    $token = 'tokens=';
                    $call_back = base_url('billing/' . $type . $call . $token . '' .  $data['token']);
                    $data_pay = $this->zarinpal->send($merchant_id, $amount, $desc, $call_back);
                    $error = $data_pay;
                    break;
                case 3:
                    $fname = 'pinpay';
                    break;
                case 4:
                    $fname = 'paypal';
                    break;
                case 5:
                    $fname = 'securepay';
                    break;
                case 6:
                    $fname = 'checkout';
                    break;
                case 7:
                    $fname = 'payumoney';
                    break;
                case 8:
                    $fname = 'razor';
                    break;
                default:
                    $fname = 'stripe';
                    break;
            }

            $tokens = $this->input->get('token');
            $number_invoice = $this->input->get('id');
            $data['error'] = 'تراکنش ناموفق';
            $data['color'] = 'danger';
            $data['header'] = 'تراکنش ناموفق بود';
            $data['message'] =  $error;
            $data['info'] = 'لطفا مجدد امتحان نمایید.';
            $data['url'] = base_url() . 'billing/view?id=' .  $number_invoice . '&token=' .  $tokens;
            $this->load->view('alert/info-card/index', $data);
        } else {
            echo '<h3>' . $this->lang->line('Online Payment Service') . '</h3>';
        }
    }
    public function calback()
    {
        $tid = $this->input->get('id');
        // get data invoice
        $this->load->model('invoices_model', 'invocies');
        $data['invoice'] = $this->invocies->invoice_details($tid);
        // get merchant code
        $this->load->model('billing_model', 'billing');
        $data['gateway'] = $this->billing->gateway('1');
        $merchant_code = $data['gateway']['key1'];
        // get amount invoice
        $subtotal_pay = $data['invoice']['subtotal'];
        $pay_amount = $data['invoice']['pamnt'];
        $rming = $subtotal_pay - $pay_amount;
        if ($rming < 0) {
            $rming = 0;
        }
        $currency = $data['gateway']['currency'];
        if ($currency == 'toman') {
            $factor = '10';
        } else {
            $factor = '1';
        }
        $payed = amountExchange_pay(number_format($rming, 0, '.', ''), $data['invoice']['multi']) * $factor;
        // zarinpal code
        $Authority = $_GET['Authority'];
        $data = array("merchant_id" => $merchant_code, "authority" => $Authority, "amount" => $payed);
        $jsonData = json_encode($data);
        $ch = curl_init('https://api.zarinpal.com/pg/v4/payment/verify.json');
        curl_setopt($ch, CURLOPT_USERAGENT, 'ZarinPal Rest Api v4');
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($jsonData)
        ));

        $result = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($result, true);
        if ($err) {
            $error = $this->zarinpal->check($result['errors']['code']);
            $tokens = $this->input->get('token');
            $number_invoice = $this->input->get('id');
            $data['error'] = 'تراکنش ناموفق';
            $data['color'] = 'danger';
            $data['header'] = 'تراکنش ناموفق بود';
            $data['message'] =  $error;
            $data['info'] = 'لطفا مجدد امتحان نمایید.';
            $data['url'] = base_url() . 'billing/view?id=' .  $number_invoice . '&token=' .  $tokens;
            $this->load->view('alert/info-card/index', $data);
        } else {
            if ($result['data']['code'] == 100) {

                $tid = $this->input->get('id'); //شماره فاکتور
                // get data invoice
                $this->load->model('invoices_model', 'invocies');
                $data['invoice'] = $this->invocies->invoice_details($tid);
                // get merchant code
                $this->load->model('billing_model', 'billing');
                $data['gateway'] = $this->billing->gateway('1');
                $merchant_code = $data['gateway']['key1'];
                // get amount invoice
                $subtotal_pay = $data['invoice']['subtotal'];
                $pay_amount = $data['invoice']['pamnt'];
                $rming = $subtotal_pay - $pay_amount;
                if ($rming < 0) {
                    $rming = 0;
                }

                $amount = amountExchange_pay(number_format($rming, 0, '.', ''), $data['invoice']['multi']);
                $paydate = $paydate = $this->jdf->s_jalali_to_gregorian($this->jdf->jdate('Y/m/d'));
                $note = $this->lang->line('Online payment with transaction number') . $Authority;
                $pmethod = 'Card';
                $acid = $data['invoice']['csd'];
                $cid = $data['invoice']['csd'];
                $cname = $data['invoice']['name'];
                $paydate = datefordatabase($paydate);

                $this->db->select('holder');
                $this->db->from('accounts');
                $this->db->where('id', $acid);
                $query = $this->db->get();
                $account = $query->row_array();
                if ($pmethod == 'Balance') {
                    $customer = $this->transactions->check_balance($cid);
                    if ($customer['balance'] >= $amount) {
                        $this->db->set('balance', "balance-$amount", FALSE);
                        $this->db->where('id', $cid);
                        $this->db->update('customers');
                    } else {
                        $amount = $customer['balance'];
                        $this->db->set('balance', 0, FALSE);
                        $this->db->where('id', $cid);
                        $this->db->update('customers');
                    }
                }
                $data = array(
                    'acid' => $acid,
                    'account' => $cname,
                    'type' => 'Income',
                    'cat' => 'Sales',
                    'credit' => $amount,
                    'payer' => $cname,
                    'payerid' => $cid,
                    'method' => $pmethod,
                    'date' => $paydate,
                    'eid' => $cid,
                    'tid' => $tid,
                    'note' => $note,
                    'ext' => '0'
                );
                $this->db->insert('transactions', $data);
                //$this->db->insert_id();
                $this->db->select('total,csd,pamnt');
                $this->db->from('invoices');
                $this->db->where('tid', $tid);
                $query = $this->db->get();
                $invresult = $query->row();
                $totalrm = $invresult->total - $invresult->pamnt;
                if ($totalrm > $amount) {
                    $this->db->set('pmethod', $pmethod);
                    $this->db->set('pamnt', "pamnt+$amount", FALSE);

                    $this->db->set('status', 'partial');
                    $this->db->where('tid', $tid);
                    $this->db->update('invoices');
                    //account update
                    $this->db->set('lastbal', "lastbal+$amount", FALSE);
                    $this->db->where('id', $acid);
                    $this->db->update('accounts');
                    $paid_amount = $invresult->pamnt + $amount;
                    $status = 'Partial';
                    $totalrm = $totalrm - $amount;
                } else {
                    if ($totalrm < $amount) {
                        $diff = $totalrm - $amount;
                        $diff = abs($diff);
                        $amount = $totalrm;
                        $this->db->set('balance', "balance+$diff", FALSE);
                        $this->db->where('id', $cid);
                        $this->db->update('customers');
                    }
                    $this->db->set('pmethod', $pmethod);
                    $this->db->set('pamnt', "pamnt+$totalrm", FALSE);
                    $this->db->set('status', 'paid');
                    $this->db->where('tid', $tid);
                    $this->db->update('invoices');
                    //account update
                    $this->db->set('lastbal', "lastbal+$totalrm", FALSE);
                    $this->db->where('id', $acid);
                    $this->db->update('accounts');

                    $totalrm = 0;
                    $status = 'Paid';
                }
                $tokens = $this->input->get('token');
                $number_invoice = $this->input->get('id');
                $data['error'] = 'تراکنش موفق';
                $data['color'] = 'success';
                $data['header'] = 'پرداخت با موفقیت انجام شد.';
                $data['message'] = 'مشتری گرامی پرداخت شما با موفقیت انجام شد';
                $data['info'] =  ' شناسه ی پرداخت ' . $Authority;
                $data['url'] = base_url() . 'billing/view?id=' .  $number_invoice . '&token=' .  $tokens;
                $this->load->view('alert/info-card/index', $data);
            } else {
                $error = $this->zarinpal->check($result['errors']['code']);
                $tokens = $this->input->get('token');
                $number_invoice = $this->input->get('id');
                $data['error'] = 'تراکنش ناموفق';
                $data['color'] = 'danger';
                $data['header'] = 'تراکنش ناموفق بود';
                $data['message'] =  $error;
                $data['info'] = 'لطفا مجدد امتحان نمایید.';
                $data['url'] = base_url() . 'billing/view?id=' .  $number_invoice . '&token=' .  $tokens;
                $this->load->view('alert/info-card/index', $data);
            }
        }
    }
    //end zarinpal codes card

    public function calback_invoice()
    {
        // get data
        $this->load->model('Zarinpal_model');
        $merchant_data = $this->Zarinpal_model->merchant_code('1');
        $merchant_code =  $merchant_data[0]->key1; //مرچند کد
        // get data id and amount invoice
        $tid = $this->input->get('id'); //شماره فاکتور
        $data = $this->Zarinpal_model->invoices_all_data_rec($tid);
        $subtotal = $data[0]->subtotal;
        $pamnt = $data[0]->pamnt;
        $pay = $subtotal - $pamnt;
        $amount = amountExchange_pay(number_format($pay, 0, '.', ''), $data['invoice']['multi']);
        // end data
        $Authority = $_GET['Authority'];
        $data = array("merchant_id" => $merchant_code, "authority" => $Authority, "amount" =>  $amount);
        $jsonData = json_encode($data);
        $ch = curl_init('https://api.zarinpal.com/pg/v4/payment/verify.json');
        curl_setopt($ch, CURLOPT_USERAGENT, 'ZarinPal Rest Api v4');
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($jsonData)
        ));

        $result = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($result, true);
        if ($err) {
            $error = $this->zarinpal->check($result['errors']['code']);
            $tokens = $this->input->get('token');
            $number_invoice = $this->input->get('id');
            $data['error'] = 'تراکنش ناموفق';
            $data['color'] = 'danger';
            $data['header'] = 'تراکنش ناموفق بود';
            $data['message'] =  $error;
            $data['info'] = 'لطفا مجدد امتحان نمایید.';
            $data['url'] = base_url() . 'billing/view?id=' .  $number_invoice . '&token=' .  $tokens;
            $this->load->view('alert/info-card/index', $data);
        } else {
            if ($result['data']['code'] == 100) {
                // code
                // get data id and amount invoice
                $tid = $this->input->get('id'); //شماره فاکتور
                $data = $this->Zarinpal_model->invoices_select_rec($tid);
                $id_invoice = $data[0]->subtotal;
                // start code
                $data = $this->Zarinpal_model->invoices_all_data_rec($tid);
                $subtotal = $data[0]->subtotal;
                $pamnt = $data[0]->pamnt;
                $pay = $subtotal - $pamnt;
                $amount = amountExchange_pay(number_format($pay, 0, '.', ''), $data['invoice']['multi']);

                $paydate = $this->jdf->s_jalali_to_gregorian($this->jdf->jdate('Y/m/d')); //تاریخ پرداخت
                $note = '  پرداخت آنلاین با شماره تراکنش' . $Authority; //توضیح کوتاه
                $pmethod = 'Card'; //شیوه پرداخت
                $acid = $data[0]->csd; //حساب کاربری 
                $cid = $data[0]->csd; //آی دی مشتری
                $cname = $this->Zarinpal_model->name_customer($cid);
                $paydate = $this->jdf->s_jalali_to_gregorian($this->jdf->jdate('Y/m/d')); //تاریخ پرداخت

                $this->db->select('holder');
                $this->db->from('accounts');
                $this->db->where('id', $acid);
                $query = $this->db->get();
                $account = $query->row_array();

                if ($pmethod == 'Balance') {

                    $customer = $this->transactions->check_balance($cid);
                    if ($customer['balance'] >= $amount) {
                        $this->db->set('balance', "balance-$amount", FALSE);
                        $this->db->where('id', $cid);
                        $this->db->update('customers');
                    } else {

                        $amount = $customer['balance'];
                        $this->db->set('balance', 0, FALSE);
                        $this->db->where('id', $cid);
                        $this->db->update('customers');
                    }
                }

                $data = array(
                    'acid' => $acid,
                    'account' => $cname[0]->name,
                    'type' => 'Income',
                    'cat' => 'Sales',
                    'credit' => $amount,
                    'payer' => $cname[0]->name,
                    'payerid' => $cid,
                    'method' => 'Card',
                    'date' => $paydate,
                    'eid' =>  $cid,
                    'tid' => $tid,
                    'note' => $note,
                    'ext' => '2'
                );

                $this->db->insert('transactions', $data);
                //$this->db->insert_id();

                $this->db->select('total,csd,pamnt');
                $this->db->from('rec_invoices');
                $this->db->where('tid', $tid);
                $query = $this->db->get();
                $invresult = $query->row();

                $totalrm = $invresult->total - $invresult->pamnt;

                if ($totalrm > $amount) {
                    $this->db->set('pmethod', $pmethod);
                    $this->db->set('pamnt', "pamnt+$amount", FALSE);

                    $this->db->set('status', 'partial');
                    $this->db->where('tid', $tid);
                    $this->db->update('rec_invoices');


                    //account update
                    $this->db->set('lastbal', "lastbal+$amount", FALSE);
                    $this->db->where('id', $acid);
                    $this->db->update('accounts');
                    $paid_amount = $invresult->pamnt + $amount;
                    $status = 'Partial';
                    $totalrm = $totalrm - $amount;
                } else {
                    if ($totalrm < $amount) {
                        $diff = $totalrm - $amount;
                        $diff = abs($diff);
                        $amount = $totalrm;
                        $this->db->set('balance', "balance+$diff", FALSE);
                        $this->db->where('id', $cid);
                        $this->db->update('customers');
                    }
                    $this->db->set('pmethod', $pmethod);
                    $this->db->set('pamnt', "pamnt+$totalrm", FALSE);
                    $this->db->set('status', 'paid');
                    $this->db->where('tid', $tid);
                    $this->db->update('rec_invoices');
                    //account update
                    $this->db->set('lastbal', "lastbal+$totalrm", FALSE);
                    $this->db->where('id', $acid);
                    $this->db->update('accounts');

                    $totalrm = 0;
                    $status = 'Paid';
                }

                $tokens = $this->input->get('token');
                $number_invoice = $this->input->get('id');
                $data['error'] = 'تراکنش موفق';
                $data['color'] = 'success';
                $data['header'] = 'پرداخت با موفقیت انجام شد.';
                $data['message'] = 'مشتری گرامی پرداختی شما با موفقیت انجام شد.';
                $data['info'] =  'شناسه ی پرداخت ' . $Authority;
                $data['url'] = base_url() . 'billing/invoice?id=' .  $number_invoice . '&token=' .  $tokens;
                $this->load->view('alert/info-card/index', $data);
            } else {
                $error = $this->zarinpal->check($result['errors']['code']);
                $tokens = $this->input->get('token');
                $number_invoice = $this->input->get('id');
                $data['error'] = 'تراکنش ناموفق';
                $data['color'] = 'danger';
                $data['header'] = 'تراکنش ناموفق بود';
                $data['message'] =  $error;
                $data['info'] = 'لطفا مجدد امتحان نمایید.';
                $data['url'] = base_url() . 'billing/invoice?id=' .  $number_invoice . '&token=' .  $tokens;
                $this->load->view('alert/info-card/index', $data);
            }
        }
    }
    //end zarinpal codes card
    public function process_card()
    {

        $online_pay = $this->billing->online_pay_settings();
        /*zarinpal pay*/
        $data['gateway'] = $this->billing->gateway('stripe');
        if ($online_pay['enable'] == 1) {

            $merchant_id = $data['gateway']['key1'];
            $amount = number_format($data['invoice']['total'], 0, '.', '');
        }
        /**zarinpal code  */
        $Authority = $_GET['Authority'];
        $data = array("merchant_id" =>   $merchant_id, "authority" => $Authority, "amount" => $amount);
        $jsonData = json_encode($data);
        $ch = curl_init('https://api.zarinpal.com/pg/v4/payment/verify.json');
        curl_setopt($ch, CURLOPT_USERAGENT, 'ZarinPal Rest Api v4');
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($jsonData)
        ));

        $result = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($result, true);
        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            if ($result['data']['code'] == 100) {
                echo json_encode(array('status' => 'خطا', 'message' =>
                'تست درگاه'));
            } else {
                echo json_encode(array('status' => 'خطا', 'message' =>
                $this->lang->line('Payment failed')));
            }
        }
    }
    // pay calback
    public function calbackpay()
    {
        $tid = $this->input->get('id');

        // get data invoice
        $this->load->model('invoices_model', 'invocies');
        $data['invoice'] = $this->invocies->invoice_details($tid);
        // get merchant code
        $this->load->model('billing_model', 'billing');
        $data['gateway'] = $this->billing->gateway('2');
        $merchant_code = $data['gateway']['key1'];
        // get amount invoice
        $subtotal_pay = $data['invoice']['subtotal'];
        $pay_amount = $data['invoice']['pamnt'];
        $rming = $subtotal_pay - $pay_amount;
        if ($rming < 0) {
            $rming = 0;
        }
        $amount = amountExchange_pay(number_format($rming, 0, '.', ''), $data['invoice']['multi']);
        // pay code
        $token_pay = $_GET['token'];
        $result = json_decode($this->zarinpal->verify($merchant_code, $token_pay));
        // end pay
        if (isset($result->status)) {
            if ($result->status == 1) {
                $tid = $this->input->get('id'); //شماره فاکتور
                // get data invoice
                $this->load->model('invoices_model', 'invocies');
                $data['invoice'] = $this->invocies->invoice_details($tid);
                // get merchant code
                $this->load->model('billing_model', 'billing');
                $data['gateway'] = $this->billing->gateway('2');
                $merchant_code = $data['gateway']['key1'];
                // get amount invoice
                $subtotal_pay = $data['invoice']['subtotal'];
                $pay_amount = $data['invoice']['pamnt'];
                $rming = $subtotal_pay - $pay_amount;
                if ($rming < 0) {
                    $rming = 0;
                }
                $amount = amountExchange_pay(number_format($rming, 0, '.', ''), $data['invoice']['multi']);
                $paydate = $paydate = $this->jdf->s_jalali_to_gregorian($this->jdf->jdate('Y/m/d'));
                $note  = $this->lang->line('Online payment with transaction number') . ' ' . $result->transId;
                $pmethod = 'Card';
                $acid = $data['invoice']['csd'];
                $cid = $data['invoice']['csd'];
                $cname = $data['invoice']['name'];
                $paydate = datefordatabase($paydate);

                $this->db->select('holder');
                $this->db->from('accounts');
                $this->db->where('id', $acid);
                $query = $this->db->get();
                $account = $query->row_array();
                if ($pmethod == 'Balance') {

                    $customer = $this->transactions->check_balance($cid);
                    if ($customer['balance'] >= $amount) {

                        $this->db->set('balance', "balance-$amount", FALSE);
                        $this->db->where('id', $cid);
                        $this->db->update('customers');
                    } else {

                        $amount = $customer['balance'];
                        $this->db->set('balance', 0, FALSE);
                        $this->db->where('id', $cid);
                        $this->db->update('customers');
                    }
                }
                $data = array(
                    'acid' => $acid,
                    'account' => $cname,
                    'type' => 'Income',
                    'cat' => 'Sales',
                    'credit' => $amount,
                    'payer' => $cname,
                    'payerid' => $cid,
                    'method' => $pmethod,
                    'date' => $paydate,
                    'eid' => $cid,
                    'tid' => $tid,
                    'note' => $note,
                    'ext' => '0'
                );
                $this->db->insert('transactions', $data);
                //$this->db->insert_id();
                $this->db->select('total,csd,pamnt');
                $this->db->from('invoices');
                $this->db->where('tid', $tid);
                $query = $this->db->get();
                $invresult = $query->row();
                $totalrm = $invresult->total - $invresult->pamnt;
                if ($totalrm > $amount) {
                    $this->db->set('pmethod', $pmethod);
                    $this->db->set('pamnt', "pamnt+$amount", FALSE);

                    $this->db->set('status', 'partial');
                    $this->db->where('tid', $tid);
                    $this->db->update('invoices');
                    //account update
                    $this->db->set('lastbal', "lastbal+$amount", FALSE);
                    $this->db->where('id', $acid);
                    $this->db->update('accounts');
                    $paid_amount = $invresult->pamnt + $amount;
                    $status = 'Partial';
                    $totalrm = $totalrm - $amount;
                } else {
                    if ($totalrm < $amount) {
                        $diff = $totalrm - $amount;
                        $diff = abs($diff);
                        $amount = $totalrm;
                        $this->db->set('balance', "balance+$diff", FALSE);
                        $this->db->where('id', $cid);
                        $this->db->update('customers');
                    }
                    $this->db->set('pmethod', $pmethod);
                    $this->db->set('pamnt', "pamnt+$totalrm", FALSE);
                    $this->db->set('status', 'paid');
                    $this->db->where('tid', $tid);
                    $this->db->update('invoices');
                    //account update
                    $this->db->set('lastbal', "lastbal+$totalrm", FALSE);
                    $this->db->where('id', $acid);
                    $this->db->update('accounts');

                    $totalrm = 0;
                    $status = 'Paid';
                }
                $tokens = $this->input->get('tokens');
                $number_invoice = $this->input->get('id');
                $data['error'] = 'تراکنش موفق';
                $data['color'] = 'success';
                $data['header'] = 'پرداخت با موفقیت انجام شد.';
                $data['message'] = 'مشتری گرامی پرداخت شما با موفقیت انجام شد';
                $data['info'] =  ' شناسه ی پرداخت ' . $result->transId;
                $data['url'] = base_url() . 'billing/view?id=' .  $number_invoice . '&token=' .  $tokens;
                $this->load->view('alert/info-card/index', $data);
            } else {
                $number_invoice =  $tid;
                $token_data = $this->input->get('tokens');
                $data['error'] = 'تراکنش ناموفق';
                $data['color'] = 'danger';
                $data['header'] = 'تراکنش ناموفق بود';
                $data['message'] = $result->status;
                $data['info'] = 'لطفا مجدد امتحان نمایید.';
                $data['url'] = base_url() . 'billing/view?id=' .  $number_invoice . '&token=' .     $token_data;
                $this->load->view('alert/info-card/index', $data);
            }
        } else {
            if ($_GET['status'] == 0) {
                $number_invoice =  $tid;
                $token_data = $this->input->get('tokens');
                $data['error'] = 'تراکنش ناموفق';
                $data['color'] = 'danger';
                $data['header'] = 'تراکنش ناموفق بود';
                $data['message'] =  $_GET['status'];
                $data['info'] = 'لطفا مجدد امتحان نمایید.';
                $data['url'] = base_url() . 'billing/view?id=' .  $number_invoice . '&token=' .     $token_data;
                $this->load->view('alert/info-card/index', $data);
            }
        }
    }
    public function calback_invoice_pay()
    {
        // get data
        $this->load->model('Zarinpal_model');
        $merchant_data = $this->Zarinpal_model->merchant_code('2');
        $merchant_code =  $merchant_data[0]->key1; //مرچند کد
        // get data id and amount invoice
        $tid = $this->input->get('id'); //شماره فاکتور
        $data = $this->Zarinpal_model->invoices_all_data_rec($tid);
        $subtotal = $data[0]->subtotal;
        $pamnt = $data[0]->pamnt;
        $pay = $subtotal - $pamnt;
        $amount = amountExchange_pay(number_format($pay, 0, '.', ''), $data['invoice']['multi']);
        // end data
        $token_pay = $_GET['token'];
        $result = json_decode($this->zarinpal->verify($merchant_code, $token_pay));
        // end pay
        if (isset($result->status)) {
            if ($result->status == 1) {
                $tid = $this->input->get('id'); //شماره فاکتور
                $data = $this->Zarinpal_model->invoices_select_rec($tid);
                $id_invoice = $data[0]->subtotal;
                // start code
                $data = $this->Zarinpal_model->invoices_all_data_rec($tid);
                $subtotal = $data[0]->subtotal;
                $pamnt = $data[0]->pamnt;
                $pay = $subtotal - $pamnt;
                $amount = amountExchange_pay(number_format($pay, 0, '.', ''), $data['invoice']['multi']);

                $paydate = $this->jdf->s_jalali_to_gregorian($this->jdf->jdate('Y/m/d')); //تاریخ پرداخت
                $note = $this->lang->line('Online payment with transaction number') . ' ' .  $result->transId; //توضیح کوتاه
                $pmethod = 'Card'; //شیوه پرداخت
                $acid = $data[0]->csd; //حساب کاربری 
                $cid = $data[0]->csd; //آی دی مشتری
                $cname = $this->Zarinpal_model->name_customer($cid);
                $paydate = $this->jdf->s_jalali_to_gregorian($this->jdf->jdate('Y/m/d')); //تاریخ پرداخت

                $this->db->select('holder');
                $this->db->from('accounts');
                $this->db->where('id', $acid);
                $query = $this->db->get();
                $account = $query->row_array();

                if ($pmethod == 'Balance') {

                    $customer = $this->transactions->check_balance($cid);
                    if ($customer['balance'] >= $amount) {
                        $this->db->set('balance', "balance-$amount", FALSE);
                        $this->db->where('id', $cid);
                        $this->db->update('customers');
                    } else {

                        $amount = $customer['balance'];
                        $this->db->set('balance', 0, FALSE);
                        $this->db->where('id', $cid);
                        $this->db->update('customers');
                    }
                }

                $data = array(
                    'acid' => $acid,
                    'account' => $cname[0]->name,
                    'type' => 'Income',
                    'cat' => 'Sales',
                    'credit' => $amount,
                    'payer' => $cname[0]->name,
                    'payerid' => $cid,
                    'method' => 'Card',
                    'date' => $paydate,
                    'eid' =>  $cid,
                    'tid' => $tid,
                    'note' => $note,
                    'ext' => '2'
                );

                $this->db->insert('transactions', $data);
                //$this->db->insert_id();

                $this->db->select('total,csd,pamnt');
                $this->db->from('rec_invoices');
                $this->db->where('tid', $tid);
                $query = $this->db->get();
                $invresult = $query->row();

                $totalrm = $invresult->total - $invresult->pamnt;

                if ($totalrm > $amount) {
                    $this->db->set('pmethod', $pmethod);
                    $this->db->set('pamnt', "pamnt+$amount", FALSE);

                    $this->db->set('status', 'partial');
                    $this->db->where('tid', $tid);
                    $this->db->update('rec_invoices');


                    //account update
                    $this->db->set('lastbal', "lastbal+$amount", FALSE);
                    $this->db->where('id', $acid);
                    $this->db->update('accounts');
                    $paid_amount = $invresult->pamnt + $amount;
                    $status = 'Partial';
                    $totalrm = $totalrm - $amount;
                } else {
                    if ($totalrm < $amount) {
                        $diff = $totalrm - $amount;
                        $diff = abs($diff);
                        $amount = $totalrm;
                        $this->db->set('balance', "balance+$diff", FALSE);
                        $this->db->where('id', $cid);
                        $this->db->update('customers');
                    }
                    $this->db->set('pmethod', $pmethod);
                    $this->db->set('pamnt', "pamnt+$totalrm", FALSE);
                    $this->db->set('status', 'paid');
                    $this->db->where('tid', $tid);
                    $this->db->update('rec_invoices');
                    //account update
                    $this->db->set('lastbal', "lastbal+$totalrm", FALSE);
                    $this->db->where('id', $acid);
                    $this->db->update('accounts');

                    $totalrm = 0;
                    $status = 'Paid';
                }
                $tokens = $this->input->get('tokens');
                $number_invoice = $this->input->get('id');
                $data['error'] = 'تراکنش موفق';
                $data['color'] = 'success';
                $data['header'] = 'پرداخت با موفقیت انجام شد.';
                $data['message'] = 'مشتری گرامی پرداخت شما با موفقیت انجام شد';
                $data['info'] =  ' شناسه ی پرداخت ' . $result->transId;
                $data['url'] = base_url() . 'billing/invoice?id=' .  $number_invoice . '&token=' .  $tokens;
                $this->load->view('alert/info-card/index', $data);
            } else {
                $number_invoice =  $tid;
                $token_data = $this->input->get('tokens');
                $data['error'] = 'تراکنش ناموفق';
                $data['color'] = 'danger';
                $data['header'] = 'تراکنش ناموفق بود';
                $data['message'] = $result->status;
                $data['info'] = 'لطفا مجدد امتحان نمایید.';
                $data['url'] = base_url() . 'billing/invoice?id=' .  $number_invoice . '&token=' .     $token_data;
                $this->load->view('alert/info-card/index', $data);
            }
        } else {
            if ($_GET['status'] == 0) {
                $number_invoice =  $tid;
                $token_data = $this->input->get('tokens');
                $data['error'] = 'تراکنش ناموفق';
                $data['color'] = 'danger';
                $data['header'] = 'تراکنش ناموفق بود';
                $data['message'] =  $_GET['status'];
                $data['info'] = 'لطفا مجدد امتحان نمایید.';
                $data['url'] = base_url() . 'billing/view?id=' .  $number_invoice . '&token=' .     $token_data;
                $this->load->view('alert/info-card/index', $data);
            }
        }
    }
    // end calback
    private function stripe($token, $amount, $gateway_data, $tid, $customer, $currency = '')
    {
        require_once APPPATH . 'third_party/stripe-php/vendor/autoload.php';
        \Stripe\Stripe::setApiKey($gateway_data['key1']);
        $charge = \Stripe\Charge::create(['amount' => $amount, 'currency' => $gateway_data['currency'], 'source' => $token]);
        return $charge;
    }
    private function authorizenet($cardNumber, $nmonth, $nyear, $cardCVC, $amount, $tid, $gateway_data)
    {
        $gateway = Omnipay::create('AuthorizeNet_AIM');
        $gateway->setApiLoginId($gateway_data['key2']);
        $gateway->setTransactionKey($gateway_data['key1']);
        $gateway->setDeveloperMode(true);

        try {
            return $gateway->purchase(
                array(
                    'card' => array(
                        'number' => $cardNumber,
                        'expiryMonth' => $nmonth,
                        'expiryYear' => $nyear,
                        'cvv' => $cardCVC
                    ),
                    'amount' => $amount,
                    'currency' => $gateway_data['currency'],
                    'description' => 'Paid on' . $this->config->item('ctitle'),
                    'transactionId' => 'INV#' . $tid
                )
            )->send();
        } catch (Exception $e) {
            return 0;
        }
    }


    private function pinpay($cardNumber, $nmonth, $nyear, $cardCVC, $amount, $tid, $gateway_data, $customer)
    {
        $gateway = \Omnipay\Omnipay::create('Pin');

        // Initialise the gateway
        $gateway->initialize(array(
            'secretKey' => $gateway_data['key1'],
            'testMode' => $gateway_data['dev_mode'], // Or false when you are ready for live transactions
        ));

        // Create a credit card object
        // This card can be used for testing.
        // See https://pin.net.au/docs/api/test-cards for a list of card
        // numbers that can be used for testing.
        $card = new \Omnipay\Common\CreditCard(array(
            'firstName' => $customer['name'],
            'lastName' => 'Customer',
            'number' => $cardNumber,
            'expiryMonth' => $nmonth,
            'expiryYear' => $nyear,
            'cvv' => $cardCVC,
            'email' => $customer['email'],
            'billingAddress1' => $customer['address'],
            'billingCountry' => $customer['country'],
            'billingCity' => $customer['city'],
            'billingPostcode' => $customer['postbox'],
            'billingState' => $customer['region'],
        ));

        // Do a purchase transaction on the gateway
        $transaction = $gateway->purchase(array(
            'description' => 'Payment for INV#' . $tid,
            'amount' => $amount,
            'currency' => $gateway_data['currency'],
            'clientIp' => $_SERVER['REMOTE_ADDR'],
            'card' => $card,
        ));
        return $transaction->send();
    }


    private function securepay($cardNumber, $nmonth, $nyear, $cardCVC, $amount, $tid, $gateway_data)
    {


        $gateway = \Omnipay\Omnipay::create('SecurePay_SecureXML');
        $gateway->setMerchantId($gateway_data['key1']);
        $gateway->setTransactionPassword($gateway_data['key2']);
        $gateway->setTestMode($gateway_data['dev_mode']);

        // Create a credit card object
        $card = new \Omnipay\Common\CreditCard(
            [
                'number' => $cardNumber,
                'expiryMonth' => $nmonth,
                'expiryYear' => $nyear,
                'cvv' => $cardCVC,
            ]
        );

        // Perform a purchase test
        $transaction = $gateway->purchase(
            [
                'amount' => $amount,
                'currency' => $gateway_data['currency'],
                'transactionId' => 'invoice_' . $tid,
                'card' => $card,
            ]
        );

        return $transaction->send();
    }


    private function paypal($cardNumber, $nmonth, $nyear, $cardCVC, $amount, $tid, $gateway_data, $customer)
    {

        $gateway = Omnipay::create('PayPal_Rest');
        // Initialise the gateway
        $gateway->initialize(array(
            'clientId' => $gateway_data['key1'],
            'secret' => $gateway_data['key2'],
            'testMode' => $gateway_data['dev_mode'], // Or false when you are ready for live transactions
        ));

        $card = new \Omnipay\Common\CreditCard(array(
            'firstName' => $customer['name'],
            'lastName' => 'Customer',
            'number' => $cardNumber,
            'expiryMonth' => $nmonth,
            'expiryYear' => $nyear,
            'cvv' => $cardCVC,
            'billingAddress1' => $customer['address'],
            'billingCountry' => $customer['country'],
            'billingCity' => $customer['city'],
            'billingPostcode' => $customer['postbox'],
            'billingState' => $customer['state'],
        ));

        try {
            $transaction = $gateway->purchase(array(
                'amount' => $amount,
                'currency' => $gateway_data['currency'],
                'description' => 'Payment for #inv ' . $tid,
                'card' => $card,
            ));
            return $transaction->send();
        } catch (\Exception $e) {
            return false;
        }
    }

    public function bank()
    {
        $online_pay = $this->billing->online_pay_settings();
        if ($online_pay['bank'] == 1) {
            $data['accounts'] = $this->billing->bank_accounts('Yes');
            $this->load->view('billing/header-1');
            $this->load->view('payment/public_bank_view', $data);
            $this->load->view('billing/footer');
        }
    }


    public function recharge()
    {
        if (!$this->input->post()) {
            exit();
        }

        $online_pay = $this->billing->online_pay_settings();
        if ($online_pay['enable'] == 0) {
            exit();
        }
        $data['id'] = $this->input->post('id'); // آی دی کاربر
        $data['amount'] = $this->input->post('amount'); //مبلغ

        $online_pay = $this->billing->online_pay_settings();
        $data['gateway'] = $this->billing->gateway_list('Yes');

        if ($online_pay['enable'] == 1) {

            $this->load->model('Zarinpal_model');
            $merchant_data = $this->Zarinpal_model->merchant_code('1');
            $merchant_code =  $merchant_data[0]->key1;
            $call_back =  base_url('billing/recharge_process?id=' . $data['id'] . '&amount=' . $data['amount']);
            $this->zarinpal->data($merchant_code, $data['amount'],  $data['id'], $call_back);
        } else {
            echo '<h3>' . $this->lang->line('Online Payment Service') . '</h3>';
        }
        /*start copy*/

        /*end copy*/
    }
    public function recharge_process()
    {
        $amount = $this->input->get('amount');
        $id = $this->input->get('id');
        $this->load->model('Zarinpal_model');
        $merchant_data = $this->Zarinpal_model->merchant_code('1');
        $merchant_code =  $merchant_data[0]->key1;
        $Authority = $_GET['Authority'];
        $data = array("merchant_id" => $merchant_code, "authority" => $Authority, "amount" =>  $amount);
        $jsonData = json_encode($data);
        $ch = curl_init('https://api.zarinpal.com/pg/v4/payment/verify.json');
        curl_setopt($ch, CURLOPT_USERAGENT, 'ZarinPal Rest Api v4');
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($jsonData)
        ));

        $result = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($result, true);
        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            if ($result['data']['code'] == 100) {
                $this->load->model('Billing_model');
                $this->Billing_model->recharge_done($id,   $amount);

                // echo json_encode(array('status' => 'موفقیت آمیز', 'message' =>
                // $this->lang->line('Thank you for the payment') . 'شماره تراکنش' . $result['data']['ref_id']));
                redirect('crm/payments/recharge', 'refresh');
                echo json_encode(array('status' => 'Success', 'message' => $this->lang->line('Thank you for the payment')));
                // echo 'Transation success. RefID:' . $result['data']['ref_id'];
                // header('Content-Type: application/json');
                // echo json_encode(array('status' => 'موفقیت آمیز', 'message' =>
                // 'شماره تراکنش:' . $result['data']['ref_id']  . "<br>" . $this->lang->line('Thank you for the payment')  . " <a href='" . base_url('billing/view?id=' . $tid_invoice . '&token=' .  $token) . "' class='btn btn-info btn-lg'><span class='icon-file-text2' aria-hidden='true'></span> " . $this->lang->line('View') . "</a>"));

            } else {
                echo 'code: ' . $result['errors']['code'];
                echo 'message: ' .  $result['errors']['message'];
                redirect('crm/payments/recharge', 'refresh');
            }
        }
    }

    public function process_recharge()
    {
        if (!$this->input->post()) {
            exit();
        }
        $tid = $this->input->post('id', true);
        $amount = number_format($this->input->post('amount', true), 2, '.', '');
        $gateway = $this->input->post('gateway', true);
        $cardNumber = $this->input->post('cardNumber', true);
        $cardExpiry = $this->input->post('cardExpiry', true);
        $cardCVC = $this->input->post('cardCVC', true);

        $nmonth = substr($cardExpiry, 0, 2);
        $nyear = '20' . substr($cardExpiry, 5, 2);

        $note = 'پرداخت آنلاین برای #' . $tid;
        $pmethod = 'کارت بانکی ';

        $amount_o = $amount;

        $gateway_data = $this->billing->gateway($gateway);
        $surcharge = ($amount * $gateway_data['surcharge']) / 100;
        $amount_t = $amount + $surcharge;
        $this->load->model('customers_model', 'customers');
        $customer = $this->customers->details($tid);


        $amount = number_format($amount_t, 2, '.', '');


        switch ($gateway) {

            case 1:
                $response = $this->stripe($cardNumber, $nmonth, $nyear, $cardCVC, $amount, $gateway_data);
                break;
            case 2:
                $response = $this->authorizenet($cardNumber, $nmonth, $nyear, $cardCVC, $amount, $tid, $gateway_data);
                break;
            case 3:
                $response = $this->pinpay($cardNumber, $nmonth, $nyear, $cardCVC, $amount, $tid, $gateway_data, $customer);
                break;
            case 4:
                $response = $this->paypal($cardNumber, $nmonth, $nyear, $cardCVC, $amount, $tid, $gateway_data, $customer);
                break;
            case 5:
                $response = $this->securepay($cardNumber, $nmonth, $nyear, $cardCVC, $amount, $tid, $gateway_data);
                break;
        }

        // Process response
        if ($response->isSuccessful()) {

            if ($this->billing->recharge_done($tid, $amount_o)) {
                header('Content-Type: application/json');
                echo json_encode(array('status' => 'موفقیت آمیز', 'message' =>
                $this->lang->line('Thank you for the payment') . " <a href='" . base_url('crm/payments/recharge') . "' class='btn btn-info btn-lg'><span class='icon-file-text2' aria-hidden='true'></span> " . $this->lang->line('View') . "</a>"));
            }
        } elseif ($response->isRedirect()) {

            // Redirect to offsite payment gateway
            $response->redirect();
        } else {

            // Payment failed
            echo json_encode(array('status' => 'خطا', 'message' =>
            $this->lang->line('Payment failed')));
        }
    }

    public function gateway_process()
    {
        //for paypal
        $invoice = $this->input->post('id', true);
        $token = $this->input->post('token', true);

        $gateway_data = $this->billing->gateway(4);
        $paypalConfig = [
            'sandbox' => $gateway_data['dev_mode'],
            'client_id' => $gateway_data['key1'],
            'client_secret' => $gateway_data['key2'],
            'return_url' => base_url('billing/gateway_response'),
            'cancel_url' => base_url('billing/view?id=' . $invoice . '&token=' . $token)
        ];

        $this->load->library("Paypal_gateway", $paypalConfig);

        $apiContext = $this->paypal_gateway->getApiContext();


        $payer = new Payer();
        $payer->setPaymentMethod('paypal');

        // Set some example data for the payment.
        $customer = $this->invocies->invoice_details($invoice);
        if (!$customer['tid']) {
            exit();
        }
        $amount = number_format($this->input->post('amount', true), 2, '.', '');
        if ($customer['multi'] > 0) {
            $multi_currency = $this->invocies->currency_d($customer['multi']);
            //    $amount =  $amount;
            $gateway_data['currency'] = $multi_currency['code'];
        }

        $validtoken = hash_hmac('ripemd160', $invoice, $this->config->item('encryption_key'));
        $surcharge = ($amount * $gateway_data['surcharge']) / 100;
        $amount_t = $amount + $surcharge;
        $amount = number_format($amount_t, 2, '.', '');

        if (hash_equals($token, $validtoken)) {

            $amountPayable = $amount;
            $invoiceNumber = $invoice;

            $amount = new Amount();
            $amount->setCurrency($gateway_data['currency'])
                ->setTotal($amountPayable);

            $transaction = new Transaction();
            $transaction->setAmount($amount)
                ->setDescription('Some description about the payment being made')
                ->setInvoiceNumber($invoiceNumber);

            $redirectUrls = new RedirectUrls();
            $redirectUrls->setReturnUrl($paypalConfig['return_url'])
                ->setCancelUrl($paypalConfig['cancel_url']);

            $payment = new Payment();
            $payment->setIntent('sale')
                ->setPayer($payer)
                ->setTransactions([$transaction])
                ->setRedirectUrls($redirectUrls);

            try {
                $payment->create($apiContext);
                $this->billing->token($invoice, 1);
            } catch (Exception $e) {
                throw new Exception('Unable to create link for payment');
            }

            header('location:' . $payment->getApprovalLink());
            exit(1);
        }
    }

    public function gateway_response()
    {
        if (empty($this->input->get('paymentId', true)) || empty($this->input->get('PayerID', true))) {
            exit;
        }
        $gateway_data = $this->billing->gateway(4);
        $paypalConfig = [
            'sandbox' => $gateway_data['dev_mode'],
            'client_id' => $gateway_data['key1'],
            'client_secret' => $gateway_data['key2'],
            'return_url' => base_url('billing/gateway_response'),
            'cancel_url' => base_url('billing/view?id=105&token=ee2f511d44dd7f0212d46b92f2d6022754574bb3')
        ];
        $this->load->library("Paypal_gateway", $paypalConfig);
        $apiContext = $this->paypal_gateway->getApiContext();
        $paymentId = $_GET['paymentId'];
        $payment = Payment::get($paymentId, $apiContext);
        $execution = new PaymentExecution();
        $execution->setPayerId($_GET['PayerID']);
        try {
            // Take the payment
            $payment->execute($execution, $apiContext);
            try {
                $payment = Payment::get($paymentId, $apiContext);
                $data = [
                    'transaction_id' => $payment->getId(),
                    'payment_amount' => $payment->transactions[0]->amount->total,
                    'payment_status' => $payment->getState(),
                    'invoice_id' => $payment->transactions[0]->invoice_number
                ];
                $validtoken = hash_hmac('ripemd160', $data['invoice_id'], $this->config->item('encryption_key'));
                $paypalConfig['bill_url'] = base_url('billing/view?id=' . $data['invoice_id'] . '&token=' . $validtoken);
                if ($data['payment_status'] === 'approved') {
                    $customer = $this->invocies->invoice_details($data['invoice_id']);
                    $amount_o = $data['payment_amount'];

                    //$amount_o = rev_amountExchange_s($amount_o, $customer['multi'], $customer['loc']);

                    $note = 'Card Payment for #' . $customer['tid'];
                    $pmethod = 'Card';
                    if ($customer['multi'] > 0) {
                        //    $amount =  $amount;
                        $note .= ' (Currency Conversion Applied)';
                    }

                    $amount = $amount_o / (($gateway_data['surcharge'] / 100) + 1);
                    $amount_o = number_format($amount, 2, '.', '');
                    $valid = $this->billing->token($customer['tid'], 2);
                    if ($valid['rid'] == $customer['tid']) {
                        $this->billing->paynow($customer['tid'], $amount_o, $note, $pmethod);
                        $this->billing->token($customer['tid'], 3);
                    }
                    header('location:' . $paypalConfig['bill_url']);
                    exit(1);
                } else {
                    // Payment failed
                    header('location:' . $paypalConfig['bill_url']);
                    exit(1);
                }
            } catch (Exception $e) {
                // Failed to retrieve payment from PayPal
                $this->billing->token($customer['tid'], 3);
                header('location:' . base_url());
            }
        } catch (Exception $e) {
            // Failed to take payment
            $this->billing->token($customer['tid'], 3);
            header('location:' . base_url());
        }
    }

    public function process_stripe()
    {
        echo 'Payment processing do no hit back button.....';
    }

    public function process_paypal()
    {

        $gateway_data = $this->billing->gateway(4);

        $clientId = $gateway_data['key1']; //$paypal_conf['client_id'];
        $clientSecret = $gateway_data['key2']; //$paypal_conf['secret'];

        if ($gateway_data['dev_mode'] == 'true') {
            $environment = new \PayPalCheckoutSdk\Core\SandboxEnvironment($clientId, $clientSecret);
        } else {
            $environment = new \PayPalCheckoutSdk\Core\ProductionEnvironment($clientId, $clientSecret);
        }

        $ord_id = $this->input->post('order', true);

        $order = $this->invocies->invoice_details($ord_id);

        $surcharge = ($order['total'] * $gateway_data['surcharge']) / 100;
        $amount_t = $order['total'] + $surcharge;

        $client = new \PayPalCheckoutSdk\Core\PayPalHttpClient($environment);
        $request = new \PayPalCheckoutSdk\Orders\OrdersCreateRequest();
        $request->prefer('return=representation');
        $request->body = [
            "intent" => "CAPTURE",
            'image_url' => 'https://carrsdigital.net/invoices/assets/gateway_logo/PayPalBanner.png',
            "purchase_units" => [[
                "reference_id" =>  $order['tid'],
                "amount" => [
                    "value" => number_format($amount_t, 2, '.', ''),
                    "currency_code" => $gateway_data['currency']
                    //put other details here as well related to your order
                ]
            ]],
            "application_context" => [
                "cancel_url" => '',
                "return_url" => ''
            ]
        ];
        try {
            // Call API with your client and get a response for your call
            $response = $client->execute($request);

            // If call returns body in response, you can get the deserialized version from the result attribute of the response
            echo json_encode($response);
        } catch (HttpException $ex) {
            echo $ex->statusCode;
            //echo json_encode($ex->getMessage());
        }
    }


    public function paypal_capture()
    {
        $gateway_data = $this->billing->gateway(4);

        $orderId = $this->input->post('orderID', true);
        $itype = $this->input->post('itype', true);


        $clientId = $gateway_data['key1']; //$paypal_conf['client_id'];
        $clientSecret = $gateway_data['key2']; //$paypal_conf['secret'];

        if ($gateway_data['dev_mode'] == true) {
            $environment = new \PayPalCheckoutSdk\Core\SandboxEnvironment($clientId, $clientSecret);
        } else {
            $environment = new \PayPalCheckoutSdk\Core\ProductionEnvironment($clientId, $clientSecret);
        }

        $client = new \PayPalCheckoutSdk\Core\PayPalHttpClient($environment);

        $request = new \PayPalCheckoutSdk\Orders\OrdersCaptureRequest($orderId);
        $request->prefer('return=representation');
        try {

            $response = $client->execute($request);

            echo json_encode($response);

            $response = json_decode(json_encode($response), true);

            if (isset($response['result']) and $response['result']['intent'] == 'CAPTURE' and $response['result']['status'] == 'COMPLETED') {

                $note = 'INV ' . $response['result']['purchase_units'][0]['reference_id'] . ' Paypal Payment #' . $response['result']['id'];


                //              $surcharge = ($response['result']['purchase_units'][0]['amount']['value'] * $gateway_data['surcharge']) / 100;
                //   $amount_t = $response['result']['purchase_units'][0]['amount']['value'] - $surcharge;


                $this->billing->paynow($response['result']['purchase_units'][0]['reference_id'],  $response['result']['purchase_units'][0]['amount']['value'], $note, 'Card', $itype);
            }
        } catch (HttpException $ex) {

            echo json_encode(array('status' => 'خطا', 'message' => 'کد ' . $ex->statusCode . $this->lang->line(' Contact to seller.')));
        }
    }
}
