<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 *
 * Libraries Zarinpal
 *
 * This Libraries for ...
 * 
 * @package		CodeIgniter
 * @category	Libraries
 * @author    Setiawan Jodi <jodisetiawan@fisip-untirta.ac.id>
 * @link      https://github.com/setdjod/myci-extension/
 * @param     ...
 * @return    ...
 *
 */

class Zarinpal
{

  // ------------------------------------------------------------------------

  public function __construct()
  {
    // 
  }

  // ------------------------------------------------------------------------


  // ------------------------------------------------------------------------

  public function index()
  {
    // 
  }
  public function data($merchant_id, $amount, $desc, $call_back)
  {
    $data = array(
      "merchant_id" => $merchant_id,
      "amount" => $amount,
      "callback_url" => $call_back,
      "description" => $desc,
      "metadata" => ["email" => "info@email.com", "mobile" => "09121234567"],
    );
    $jsonData = json_encode($data);
    $ch = curl_init('https://api.zarinpal.com/pg/v4/payment/request.json');
    curl_setopt($ch, CURLOPT_USERAGENT, 'ZarinPal Rest Api v1');
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
      'Content-Type: application/json',
      'Content-Length: ' . strlen($jsonData)
    ));
    $result = curl_exec($ch);
    $err = curl_error($ch);
    $result = json_decode($result, true, JSON_PRETTY_PRINT);
    curl_close($ch);
    if ($err) {
      return "cURL Error #:" . $err;
    } else {
      if (empty($result['errors'])) {
        if ($result['data']['code'] == 100) {
          header('Location: https://www.zarinpal.com/pg/StartPay/' . $result['data']["authority"]);
        }
      } else {
        return 'Error Code: ' . $result['errors']['code'];
      }
    }
  }
  public function check($code)
  {
    switch ($code) {
      case '-9':
        $message = 'خطای اعتبار سنجی';
        break;
      case '-10':
        $message = 'آی پی یا مرچنت کد پذیرنده صحیح نیست';
        break;
      case '-11':
        $message = 'مرچنت کد فعال نیست لطفا با تیم پشتیبانی ما تماس بگیرید';
        break;
      case '-12':
        $message = 'تلاش بیش از حد در یک بازه زمانی کوتاه';
        break;
      case '-15':
        $message = 'ترمینال شما به حالت تعلیق در آمده با تیم پشتیبانی تماس بگیرید';
        break;
      case '-16':
        $message = 'سطح تاييد پذيرنده پايين تر از سطح نقره اي است';
        break;
      case '-30':
        $message = 'اجازه دسترسی به تسویه اشتراکی شناور ندارید';
        break;
      case '-31':
        $message = 'حساب بانکی تسویه را به پنل اضافه کنید مقادیر وارد شده واسه تسهیم درست نیست';
        break;
      case '-33':
        $message = 'درصد های وارد شده درست نیست';
        break;
      case '-34':
        $message = 'مبلغ از کل تراکنش بیشتر است';
        break;
      case '-35':
        $message = 'تعداد افراد دریافت کننده تسهیم بیش از حد مجاز است';
        break;
      case '-50':
        $message = 'مبلغ پرداخت شده با مقدار مبلغ در وریفای متفاوت است';
        break;
      case '-51':
        $message = 'پرداخت ناموفق';
        break;
      case '-52':
        $message = 'خطای غیر منتظره با پشتیبانی تماس بگیرید';
        break;
      case '-53':
        $message = 'اتوریتی برای این مرچنت کد نیست';
        break;
      case '-54':
        $message = 'اتوریتی نامعتبر است';
        break;
      case '101':
        $message = 'تراکنش وریفای شده';
        break;
      default:
        $message = "خطا " . '<br>' . $code;
        break;
    }

    return $message;
  }

  // pay getway codes

  public function send($api, $amount, $description, $redirect, $mobile = null, $factorNumber = null)
  {
    $data = $this->curl_post('https://pay.ir/pg/send', [
      'api'          => $api,
      'amount'       => $amount,
      'redirect'     => $redirect,
      'mobile'       => $mobile,
      'factorNumber' => $factorNumber,
      'description'  => $description,
    ]);
    $result = json_decode($data);
    if ($result->status) {
      $go = "https://pay.ir/pg/$result->token";
      header("Location: $go");
    } else {
      return $result->errorMessage;
    }
  }

  public function verify($api, $token)
  {
    return $this->curl_post('https://pay.ir/pg/verify', [
      'api'   => $api,
      'token' => $token,
    ]);
  }

  public function curl_post($url, $params)
  {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
      'Content-Type: application/json',
    ]);
    $res = curl_exec($ch);
    curl_close($ch);

    return $res;
  }

  // end pay code
}

/* End of file Zarinpal.php */
/* Location: ./application/libraries/Zarinpal.php */