<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\Proxy;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class ServiceOptions
{
    /**
     * @param string $friendlyName A human readable description of this resource
     * @param boolean $autoCreate Boolean flag specifying whether to auto-create
     *                            threads.
     * @param string $callbackUrl URL Twilio will request for callbacks.
     * @return CreateServiceOptions Options builder
     */
    public static function create($friendlyName = Values::NONE, $autoCreate = Values::NONE, $callbackUrl = Values::NONE)
    {
        return new CreateServiceOptions($friendlyName, $autoCreate, $callbackUrl);
    }

    /**
     * @param string $friendlyName A human readable description of this resource
     * @param boolean $autoCreate Boolean flag specifying whether to auto-create
     *                            threads.
     * @param string $callbackUrl URL Twilio will request for callbacks.
     * @return UpdateServiceOptions Options builder
     */
    public static function update($friendlyName = Values::NONE, $autoCreate = Values::NONE, $callbackUrl = Values::NONE)
    {
        return new UpdateServiceOptions($friendlyName, $autoCreate, $callbackUrl);
    }
}

class CreateServiceOptions extends Options
{
    /**
     * @param string $friendlyName A human readable description of this resource
     * @param boolean $autoCreate Boolean flag specifying whether to auto-create
     *                            threads.
     * @param string $callbackUrl URL Twilio will request for callbacks.
     */
    public function __construct($friendlyName = Values::NONE, $autoCreate = Values::NONE, $callbackUrl = Values::NONE)
    {
        $this->options['friendlyName'] = $friendlyName;
        $this->options['autoCreate'] = $autoCreate;
        $this->options['callbackUrl'] = $callbackUrl;
    }

    /**
     * A human readable description of this resource, up to 64 characters.
     *
     * @param string $friendlyName A human readable description of this resource
     * @return $this Fluent Builder
     */
    public function setFriendlyName($friendlyName)
    {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * Boolean flag specifying whether to create threads when a user communticates out of band.
     *
     * @param boolean $autoCreate Boolean flag specifying whether to auto-create
     *                            threads.
     * @return $this Fluent Builder
     */
    public function setAutoCreate($autoCreate)
    {
        $this->options['autoCreate'] = $autoCreate;
        return $this;
    }

    /**
     * The URL Twilio will request for callback notifications.
     *
     * @param string $callbackUrl URL Twilio will request for callbacks.
     * @return $this Fluent Builder
     */
    public function setCallbackUrl($callbackUrl)
    {
        $this->options['callbackUrl'] = $callbackUrl;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString()
    {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Preview.Proxy.CreateServiceOptions ' . implode(' ', $options) . ']';
    }
}

class UpdateServiceOptions extends Options
{
    /**
     * @param string $friendlyName A human readable description of this resource
     * @param boolean $autoCreate Boolean flag specifying whether to auto-create
     *                            threads.
     * @param string $callbackUrl URL Twilio will request for callbacks.
     */
    public function __construct($friendlyName = Values::NONE, $autoCreate = Values::NONE, $callbackUrl = Values::NONE)
    {
        $this->options['friendlyName'] = $friendlyName;
        $this->options['autoCreate'] = $autoCreate;
        $this->options['callbackUrl'] = $callbackUrl;
    }

    /**
     * A human readable description of this resource, up to 64 characters.
     *
     * @param string $friendlyName A human readable description of this resource
     * @return $this Fluent Builder
     */
    public function setFriendlyName($friendlyName)
    {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * Boolean flag specifying whether to create threads when a user communticates out of band.
     *
     * @param boolean $autoCreate Boolean flag specifying whether to auto-create
     *                            threads.
     * @return $this Fluent Builder
     */
    public function setAutoCreate($autoCreate)
    {
        $this->options['autoCreate'] = $autoCreate;
        return $this;
    }

    /**
     * The URL Twilio will request for callback notifications.
     *
     * @param string $callbackUrl URL Twilio will request for callbacks.
     * @return $this Fluent Builder
     */
    public function setCallbackUrl($callbackUrl)
    {
        $this->options['callbackUrl'] = $callbackUrl;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString()
    {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Preview.Proxy.UpdateServiceOptions ' . implode(' ', $options) . ']';
    }
}