<div class="container bootstrap snippets bootdeys">
    <div class="row">
        <div class="col-sm-12">
            <div class="panel panel-default invoice" id="invoice">
                <div class="panel-body">
                    <div class="invoice-ribbon">
                        <?php $status = ucwords($invoice['status']);
                        if ($status == "Paid") {
                            $class = "ribbon-inner success";
                        } else {
                            $class = "ribbon-inner warning";
                        }
                        ?>
                        <div class="<?php echo  $class; ?>"><?php echo $this->lang->line(ucwords($invoice['status'])) ?></div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6 top-right">
                            <h1 class="marginright lead"> <?php echo $this->lang->line('INVOICE') . ':' . $this->config->item('prefix') . $invoice['tid'] ?></h1>



                            <span class="marginright lead"><?php echo   $this->lang->line('Due Date') . ': ' . $this->jdf->s_gregorian_to_jalali($invoice['invoiceduedate']) ?> </span>
                        </div>
                        <div class="col-sm-6 top-left">
                            <img src="<?php echo base_url('userfiles/company/' . $this->config->item('logo')) ?>" class="img-responsive p-1 m-b-2" style="max-height: 120px;">
                        </div>

                    </div>
                    <hr>
                    <div class="row">
                        <!-- Invoice Items Details -->
                        <div class="col-xs-4 text-right payment-details">
                            <p class="lead marginbottom payment-info">جزئیات پرداخت</p>
                            <p class=""><?php echo  $this->lang->line('Invoice Date') . ': ' . $this->jdf->s_gregorian_to_jalali($invoice['invoicedate']) ?> </p>
                            <p><?php echo $this->lang->line('Gross Amount') . ':' . amountExchange($invoice['total'], $invoice['multi']) ?> </p>
                            <p></p>
                            <!-- btn -->
                            <div class="col-lg-12">
                                <?php

                                use Twilio\TwiML\Voice\Echo_;

                                $rming = $invoice['total'] - $invoice['pamnt'];
                                if ($invoice['status'] != 'canceled') { ?>
                                    <div class="row">


                                        <div class="col-md-12">
                                            <div class="form-group mt-2">
                                                <?php if ($online_pay['enable'] == 1) {
                                                    echo '<a class="btn btn-success" href="#' . base_url('billing/card?id=' . $invoice['tid'] . '&itype=inv&token=' . $token) . '" data-toggle="modal" data-target="#paymentCard"><i class="fa fa-credit-card"></i>پرداخت آنلاین</a> ';
                                                }
                                                if ($online_pay['bank'] == 1) {
                                                    echo '<a class="btn btn-danger"
                                                    href = "' . base_url('billing/bank') . '" role = "button" ><i
                                                        class="icon-bank" ></i > ' . $this->lang->line('Bank') . ' / ' . $this->lang->line('Cash') . '</a >';
                                                }
                                                ?>
                                                <?php
                                                if ($this->aauth->is_loggedin()) {

                                                    echo '<a class="btn btn-warning  mr-1"
                                                    href = "' . base_url('invoices/view?id=' . $invoice['tid']) . '" role = "button" ><i
                                                        class="icon-backward2" ></i > </a >';
                                                }
                                                ?>
                                            </div>
                                        </div>


                                    </div>
                                    <hr>
                                    <div class="title-action ">


                                    </div><?php } else {
                                            echo '<h2 class="btn btn-oval btn-danger">' . $this->lang->line('Cancelled') . '</h2>';
                                        } ?>
                            </div>
                            <!-- btn -->
                        </div>
                        <!--/ Invoice Items Details -->
                        <!-- Invoice Customer Details -->
                        <div class="col-xs-4 to">
                            <p class="lead marginbottom"><?php echo $this->lang->line('Bill To') . ' :' . $invoice['name']; ?></p>
                            <?php if ($invoice['company']) echo '<p>' . $this->lang->line('Company') . ':' . $invoice['company'] . ' ' . '</p>' ?>
                            <?php if ($invoice['country']) echo '<p>' . $this->lang->line('Country') . ':' . $invoice['country'] . ' - '  ?>
                            <?php if ($invoice['region']) echo  $this->lang->line('Region') . ':' . $invoice['region'] . ' - '  ?>
                            <?php if ($invoice['city']) echo $this->lang->line('City') . ':' . $invoice['city'] . '' . '</p>' ?>
                            <?php if ($invoice['address']) echo '<p>' . $this->lang->line('Address') . ':' . $invoice['address'] . ' ' . '</p>' ?>
                            <?php if ($invoice['postbox']) echo '<p>' . $this->lang->line('Postbox') . ':' . $invoice['postbox'] . ' ' . '</p>' ?>
                            <?php if ($invoice['phone']) echo '<p>' . $this->lang->line('Phone') . ':' . $invoice['phone'] . ' ' . '</p>' ?>
                            <?php if ($invoice['email']) echo '<p>' . $this->lang->line('Email') . ':' . $invoice['email'] . ' ' . '</p>' ?>
                            <?php if ($invoice['taxid']) echo '<p>' . $this->lang->line('TAX ID') . ':' . $invoice['taxid'] . ' ' . '</p>' ?>
                        </div>
                        <!-- / Invoice Customer Details -->
                        <!-- Invoice Company Details -->
                        <div class="col-xs-4 to">
                            <p class="lead marginbottom"><?php echo $this->lang->line('From') . ' :' . $this->config->item('ctitle'); ?></p>

                            <?php if ($this->config->item('country')) echo '<p>' . $this->lang->line('Country') . ':' . $this->config->item('country') . ' - '  ?>
                            <?php if ($this->config->item('region')) echo  $this->lang->line('Region') . ':' . $this->config->item('region') . ' - '  ?>
                            <?php if ($this->config->item('city')) echo $this->lang->line('City') . ':' . $this->config->item('city') . '' . '</p>' ?>
                            <?php if ($this->config->item('address')) echo '<p>' . $this->lang->line('Address') . ':' . $this->config->item('address') . ' ' . '</p>' ?>
                            <?php if ($this->config->item('postbox')) echo '<p>' . $this->lang->line('Postbox') . ':' .  $this->config->item('postbox') . ' ' . '</p>' ?>
                            <?php if ($this->config->item('phone')) echo '<p>' . $this->lang->line('Phone') . ':' . $this->config->item('phone')  . ' ' . '</p>' ?>
                            <?php if ($this->config->item('email')) echo '<p>' . $this->lang->line('Email') . ':' .  $this->config->item('email') . ' ' . '</p>' ?>

                        </div>
                        <!-- / Invoice Company Details -->


                    </div>

                    <!-- haml and lagl -->
                    <div class="row"> <?php if ($invoice['name_s']) { ?>
                            <hr>
                            <div class="col-xs-12 to">
                                <p class="lead marginbottom"><?php echo $this->lang->line('Shipping Address') ?></p>

                                <?php if ($invoice['country_s']) echo '<p>' . $this->lang->line('Country') . ':' . $invoice['country_s'] . ' - '  ?>
                                <?php if ($invoice['region_s']) echo  $this->lang->line('Region') . ':' . $invoice['region_s'] . ' - '  ?>
                                <?php if ($invoice['city_s']) echo $this->lang->line('City') . ':' . $invoice['city_s'] . '' . '</p>' ?>
                                <?php if ($invoice['address_s']) echo '<p>' . $this->lang->line('Address') . ':' . $invoice['address_s'] . ' ' . '</p>' ?>
                                <?php if ($invoice['postbox_s']) echo '<p>' . $this->lang->line('Postbox') . ':' . $invoice['postbox_s'] . ' ' . '</p>' ?>
                                <?php if ($invoice['phone_s']) echo '<p><strong>' . $this->lang->line('Phone') . ':' . $invoice['phone_s'] . '   ' ?>
                                <?php if ($invoice['email_s']) echo '   ' . $this->lang->line('Email') . ':' . $invoice['email_s'] . ' ' . '</strong></p>' ?>


                            </div>
                        <?php } ?>
                    </div>
                    <!-- haml and lagl -->
                </div>
                <div class="row table-row">
                    <table class="table table-striped" style="width: 100%;min-height: 0;overflow-x: auto;">
                        <thead>
                            <tr>
                                <th class="text-center" style="width:5%"><?php echo $this->lang->line('Row') ?></th>
                                <th class="text-right" style="width:40%"><?php echo $this->lang->line('Description'); ?></th>
                                <th class="text-right" style="width:10%"><?php echo $this->lang->line('Qty') ?></th>
                                <th class="text-right" style="width:10%"><?php echo $this->lang->line('Rate') ?></th>
                                <th class="text-right" style="width:10%"><?php echo $this->lang->line('Tax') ?></th>
                                <th class="text-right" style="width:10%"><?php echo $this->lang->line('Discount') ?></th>
                                <th class="text-right" style="width:10%"><?php echo $this->lang->line('Amount') ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $c = 1;
                            $sub_t = 0;
                            foreach ($products as $row) {
                                $sub_t += $row['price'] * $row['qty'];
                                echo '<tr>
                            <td scope="row">' . $c . '</td>
                            <td>' . $row['product'] . '</td>
                            <td>' . $row['qty'] . '</td>
                            <td>' . amountExchange($row['price'], $invoice['multi']) . '</td>
                            <td>' . amountExchange($row['totaltax'], $invoice['multi']) . ' (' . amountFormat_s($row['tax']) . '%)</td>
                            <td>' . amountExchange($row['totaldiscount'], $invoice['multi']) . ' (' . amountFormat_s($row['discount']) . $this->lang->line($invoice['format_discount']) . ')</td>
                            <td>' . amountExchange($row['subtotal'], $invoice['multi']) . '</td>
                        </tr>';
                                echo '<tr><td colspan=5>' . $row['product_des'] . '</td></tr>';
                                $c++;
                            } ?>

                        </tbody>
                    </table>

                </div>
                <div id="invoice-items-details" class="pt-2">
                    <div class="row">
                        <div class="table-responsive col-sm-12">
                        </div>
                    </div>
                    <p></p>
                    <div class="row">
                        <div class="col-md-5 col-sm-12">
                            <p class="lead"><?php echo $this->lang->line('Summary') ?></p>
                            <div class="table-responsive">
                                <table class="table">
                                    <tbody>
                                        <tr>
                                            <td><?php echo $this->lang->line('Sub Total') ?></td>
                                            <td class="text-xs-right"> <?php echo amountExchange($sub_t, $invoice['multi']) ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo $this->lang->line('TAX') ?></td>
                                            <td class="text-xs-right"><?php echo amountExchange($invoice['tax'], $invoice['multi']) ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo $this->lang->line('Discount') ?></td>
                                            <td class="text-xs-right"><?php echo amountExchange($invoice['discount'], $invoice['multi']) ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo $this->lang->line('Shipping') ?></td>
                                            <td class="text-xs-right"><?php echo amountExchange($invoice['shipping'], $invoice['multi']) ?></td>
                                        </tr>
                                        <tr>
                                            <td class="text-bold-800"><?php echo $this->lang->line('Total') ?></td>
                                            <td class="text-bold-800 text-xs-right"> <?php echo amountExchange($invoice['total'], $invoice['multi']) ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo $this->lang->line('Payment Made'); ?></td>
                                            <td class="pink text-xs-right">
                                                (-) <?php echo ' <span id="paymade">' . amountExchange($invoice['pamnt'], $invoice['multi']) ?></span></td>
                                        </tr>
                                        <tr class="bg-grey bg-lighten-4">
                                            <td class="text-bold-800"><?php echo $this->lang->line('Balance Due'); ?></td>
                                            <td class="text-bold-800 text-xs-right"> <?php $myp = '';

                                                                                        if ($rming < 0) {
                                                                                            $rming = 0;
                                                                                        }
                                                                                        echo ' <span id="paydue">' . amountExchange($rming, $invoice['multi']) . '</span></strong>'; ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="text-xs-center col-md-8">
                                <p><?php echo $this->lang->line('Authorized person'); ?></p>
                                <img src="<?php echo  base_url('userfiles/employee_sign/' . $employee['sign'])  ?>" alt="signature" class="height-100" />
                                <h6> <?php echo $employee['name'] ?></h6>
                                <p class="text-muted" <?php echo user_role($employee['roleid'])  ?>></p>
                            </div>
                        </div>
                        <div class="col-md-7 col-sm-12 text-xs-center text-md-left">
                            <div class="row">
                                <div class="col-md-11">
                                    <?php $status = ucwords($invoice['status']);
                                    if ($status == "Paid") {
                                        $color = "badge success";
                                    } else {
                                        $color = "badge warning";
                                    } ?>
                                    <p class="lead"><?php echo $this->lang->line('Payment Status') ?>:
                                        <u><span class="<?php echo $color ?>"><?php echo $this->lang->line(ucwords($invoice['status'])) ?></span></u>
                                    </p>
                                    <p class="lead"><?php echo $this->lang->line('Payment Method') ?>: <u><span class="badge primary"><?php echo $this->lang->line($invoice['pmethod']) ?></span></u>
                                    </p>

                                    <p class="lead mt-1"><br><?php echo $this->lang->line('Note') ?>:</p>
                                    <code>
                                        <?php echo $invoice['notes'] ?>
                                    </code>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Invoice Footer -->
                    <div id="invoice-footer">
                        <p class="lead"><?php echo $this->lang->line('Credit Transactions'); ?>:</p>
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th style="text-align: right;"><?php echo $this->lang->line('Date'); ?></th>
                                    <th style="text-align: right;"><?php echo $this->lang->line('Method'); ?></th>
                                    <th style="text-align: right;"><?php echo $this->lang->line('Amount'); ?></th>
                                    <th style="text-align: right;"><?php echo $this->lang->line('Note'); ?></th>


                                </tr>
                            </thead>
                            <tbody id="activity">
                                <?php foreach ($activity as $row) {

                                    echo '<tr>
                            <td >' . $this->jdf->s_gregorian_to_jalali($row['date']) . '</td>
                            <td>' . $this->lang->line($row['method']) . '</td>
                            <td>' . amountExchange($row['credit'], $invoice['multi']) . '</td>
                            <td>' . $row['note'] . '</td>
                        </tr>';
                                } ?>

                            </tbody>
                        </table>

                        <div class="row">

                            <div class="col-md-12 col-sm-12">

                                <h6><?php echo $this->lang->line('Terms & Condition'); ?></h6>
                                <p> <?php
                                    echo  '<strong>' . $invoice['termtit'] . '</strong><br>' . $invoice['terms'];
                                    ?></p>
                            </div>

                        </div>

                        <div class="">
                            <?php if ($attach) { ?>

                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th style="text-align: right;"><?php echo $this->lang->line('Files') ?></th>
                                        </tr>
                                    </thead>
                                    <tbody id="activity">
                                        <?php foreach ($attach as $row) {

                                            echo '<tr><td><a href="' . base_url() . 'userfiles/attach/' . $row['col1'] . '"><i class="btn-info btn-lg icon-download"></i> ' . $row['col1'] . ' </a></td></tr>';
                                        } ?>

                                    </tbody>

                                </table>
                            <?php } ?>
                            <div class="" style="direction: ltr; margin-left: 24px;">
                                <div class="btn-group mt-2">
                                    <button type="button" class="btn btn-warning" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="icon-print" style="direction: rtl;"></i> <?php echo $this->lang->line('Print Invoice') ?>
                                    </button>
                                    <div class="dropdown-menu" style="padding: 12px;text-align: right;direction: rtl;">
                                        <a class="dropdown-item" href="<?php echo 'printinvoice?id=' . $invoice['tid'] . '&token=' . $token; ?>"><?php echo $this->lang->line('Print') ?></a>
                                        <div class="dropdown-divider"></div>
                                        <a class="dropdown-item" href="<?php echo 'printinvoice?id=' . $invoice['tid'] . '&token=' . $token; ?>&d=1"><?php echo $this->lang->line('PDF Download') ?></a>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Footer -->
                </div>

            </div>

        </div>
    </div>
</div>

<?php if ($online_pay['enable'] == 1) { ?>
    <div id="paymentCard" class="modal fade" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content pament-->
            <div class="modal-content">
                <div class="modal-header">

                    <h4 class="modal-title"><?php echo $this->lang->line('Make Payment') ?></h4>
                    <button type="button" class="close" data-dismiss="modal" style="float: left;">&times;</button>
                </div>
                <div class="modal-body">
                    <?php
                    foreach ($gateway as $row) {
                        $cid = $row['id'];
                        $title = $row['name'];
                        if ($row['surcharge'] > 0) {
                            $surcharge_t = true;
                            $fee = '( ' . amountExchange($rming, $invoice['multi']) . '+' . amountFormat_s($row['surcharge']) . ' % کارمزد)';
                            $amount = amountExchange($rming + (($row['surcharge'] * $rming) / 100), $invoice['multi']);
                            $rmings = $rming;
                        } else {
                            $fee = '';
                            $amount = amountExchange($rming, $invoice['multi']);
                        }

                        echo '<a href="' . base_url('billing/card?id=' . $invoice['tid'] . '&itype=inv&token=' . $token) . '&gid=' . $cid . '" class="btn mb-1 btn-block blue rounded border border-info text-bold-700 border-lighten-5 "><span class=" display-block"><span class="grey">پرداخت با درگاه : </span><span class="blue font-medium-2">' . $title . ' ' . $fee . '<br><span class="grey"> مبلغ : </span>' . '' .  $amount  . '<br></span></span><br>

                        <img class="mt-1 bg-white round" style="max-width:20rem;max-height:10rem"
                                             src="' . base_url('assets/gateway_logo/' . $cid . '.png') . '">
                        </a><br>';
                    }
                    ?>
                </div>
                <div class="modal-footer" style="text-align: left;">
                    <button type="button" class="btn btn-default " data-dismiss="modal">بستن</button>
                </div>
            </div>

        </div>
    </div>
<?php } ?>
</body>

</html>