<!doctype html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Print Quote #<?php echo $invoice['tid'] ?></title>
    <style>
        body {
            color: #2B2000;
            font-family: 'vazir' !important;
            direction: rtl;
        }

        .invoice-box {
            width: 210mm;
            height: 297mm;
            margin: auto;
            padding: 4mm;
            border: 0;
            font-size: 12pt;
            line-height: 14pt;
            color: #000;
        }

        table {
            width: 100%;
            line-height: 16pt;
            text-align: right;
            border-collapse: collapse;
        }

        .plist tr td {
            line-height: 12pt;
        }

        .subtotal tr td {
            line-height: 10pt;
            padding: 6pt;
        }

        .subtotal tr td {
            border: 1px solid #ddd;
        }

        .sign {
            text-align: right;
            font-size: 10pt;
            margin-right: 110pt;
        }

        .sign1 {
            text-align: right;
            font-size: 10pt;
            margin-right: 90pt;
        }

        .sign2 {
            text-align: right;
            font-size: 10pt;
            margin-right: 115pt;
        }

        .sign3 {
            text-align: right;
            font-size: 10pt;
            margin-right: 115pt;
        }

        .terms {
            font-size: 9pt;
            line-height: 16pt;
            margin-right: 20pt;
        }

        .invoice-box table td {
            padding: 10pt 4pt 8pt 4pt;
            vertical-align: top;

        }

        .invoice-box table.top_sum td {
            padding: 0;
            font-size: 12pt;
        }

        .party tr td:nth-child(3) {
            text-align: center;
        }

        .invoice-box table tr.top table td {
            padding-bottom: 20pt;

        }

        table tr.top table td.title {
            font-size: 45pt;
            line-height: 45pt;
            color: #555;
        }

        table tr.information table td {
            padding-bottom: 20pt;
        }

        table tr.heading td {
            background: #515151;
            color: #FFF;
            padding: 6pt;

        }

        table tr.details td {
            padding-bottom: 20pt;
        }

        .invoice-box table tr.item td {
            border: 1px solid #ddd;
        }

        table tr.b_class td {
            border-bottom: 1px solid #ddd;
        }

        table tr.b_class.last td {
            border-bottom: none;
        }

        table tr.total td:nth-child(4) {
            border-top: 2px solid #fff;
            font-weight: bold;
        }

        .myco {
            width: 400pt;
        }

        .myco2 {
            width: 300pt;
        }

        .myw {
            width: 240pt;
            font-size: 14pt;
            line-height: 14pt;

        }

        .mfill {
            background-color: #eee;
        }

        .descr {
            font-size: 10pt;
            color: #515151;
        }

        .tax {
            font-size: 10px;
            color: #515151;
        }

        .t_center {
            text-align: right;

        }

        .party {
            border: #ccc 1px solid;
        }

        *,
        h1,
        h2,
        h3,
        h4,
        h5,
        h6,
        p,
        a,
        span,
        td,
        tr,
        strong {
            font-family: 'vazir' !important;
        }
    </style>
</head>

<body>
    <div class="invoice-box">
        <table dir="rtl">
            <tr>
                <td class="myco">
                    <img src="<?php echo FCPATH . 'userfiles/company/' . $this->config->item('logo') ?>" style="max-width:260px;">
                </td>
                <td>

                </td>
                <td class="myw">
                    <table class="top_sum">
                        <tr>
                            <td><?php echo $this->lang->line('Quote') ?></td>
                            <td><strong><?php echo  prefix(1) . $invoice['tid'] ?></strong></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('Quote Date') ?></td>
                            <td><strong><?php echo $this->jdf->s_gregorian_to_jalali($invoice['invoicedate']);  ?></strong></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('Valid till') ?></td>
                            <td><strong><?php echo $this->jdf->s_gregorian_to_jalali($invoice['invoiceduedate']) ?></strong></td>
                        </tr>
                        <?php if ($invoice['refer']) { ?>
                            <tr>
                                <td><?php echo $this->lang->line('Reference') ?></td>
                                <td><strong><?php echo $invoice['refer'] ?></strong></td>
                            </tr>
                        <?php } ?>
                    </table>



                </td>
            </tr>
        </table>

        <br>
        <table class="party">
            <thead>
                <tr class="heading">
                    <td> <?php echo $this->lang->line('Our Info') ?>:</td>

                    <td><?php echo $this->lang->line('Customer') ?>:</td>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>
                        <h3><?php echo $this->config->item('ctitle'); ?></h3>
                        <?php echo
                        $this->config->item('address') . '<br>' . $this->config->item('city') . ', ' . $this->config->item('region') . '<br>' . $this->config->item('country') . ' - <strong> ' . $this->config->item('postbox') . '</strong><br><strong>' . $this->lang->line('Phone') . ': ' . $this->config->item('phone') . '</strong><br> ' . $this->lang->line('Email') . ': ' . $this->config->item('email');
                        if ($this->config->item('taxno')) echo '<br><strong>' . $this->lang->line('Tax') . ' ID: ' . $this->config->item('taxno') . '</strong>';
                        ?>
                    </td>

                    <td>
                        <?php echo '<strong>' . $invoice['name'] . '</strong><br>';
                        if ($invoice['company']) echo $invoice['company'] . ' ';
                        echo $invoice['country'] . ' ' . $invoice['region'] . ' ' . $invoice['city'] . ' ' . $invoice['address'] . ' ' . $invoice['postbox'] . '<br><strong>' . $this->lang->line('Phone') . ': ' . $invoice['phone'] . '</strong><br><strong>' . $this->lang->line('Email') . ' : ' . $invoice['email'] . '</strong>';
                        if ($invoice['taxid']) echo '<br><strong>' . $this->lang->line('Tax') . ' ID: ' . $invoice['taxid'] . '</strong>';
                        ?>
                    </td>
                </tr>
            </tbody>
        </table>
        <br />
        <table class="plist" cellpadding="0" cellspacing="0">


            <tr class="heading">
                <td>
                    <?php echo $this->lang->line('Description') ?>
                </td>

                <td>
                    <?php echo $this->lang->line('Price') ?>
                </td>
                <td>
                    <?php echo $this->lang->line('Qty') ?>
                </td>
                <?php if ($invoice['tax'] > 0) echo '<td>' . $this->lang->line('Tax') . '</td>'; ?>
                <td>
                    <?php echo $this->lang->line('Discount') ?>
                </td>
                <td>
                    <?php echo $this->lang->line('SubTotal') ?>
                </td>
            </tr>

            <?php
            $fill = true;
            $sub_t = 0;
            foreach ($products as $row) {
                $sub_t += $row['price'] * $row['qty'];
                $cols = 3;
                if ($fill == true) {
                    $flag = ' mfill';
                } else {
                    $flag = '';
                }
                echo '<tr class="item' . $flag . '"> 
                            <td>' . $row['product'] . '</td>
							<td style=""><strong>' . amountExchange($row['price'], $invoice['multi']) . '</strong></td>
                            <td style=""><strong>' . $row['qty']  . '</strong></td>   ';
                if ($invoice['tax'] > 0) {
                    $cols++;
                    echo '<td style=""><strong>' . amountExchange($row['totaltax'], $invoice['multi']) . ' <span class="tax">(' . amountExchange($row['tax'], $invoice['multi']) . '%)</span></strong></td>';
                }
                echo ' <td style=""><strong>' . amountExchange($row['totaldiscount'], $invoice['multi']) . '</strong></td>
                            <td><strong>' . amountExchange($row['subtotal'], $invoice['multi']) . '</strong></td>
                        </tr>';
                if ($row['product_des']) {
                    $cc = $cols + 2;
                    echo '<tr class="item' . $flag . '"> 
                            <td colspan="' . $cc . '">' . $row['product_des'] . '<br>&nbsp;</td>
							
                        </tr>';
                }
                $fill = !$fill;
            }
            if ($invoice['shipping'] > 0) {
                $cols++;
            }
            ?>


        </table>
        <table class="subtotal">
            <thead>
            <tbody>
                <tr>
                    <td class="myco2" rowspan="<?php echo $cols ?>"><?php echo '<strong>' . $this->lang->line('Status') . ': ' . $this->lang->line(ucwords($invoice['status'])) ?></strong>
                        <hr><?php echo '' . $this->lang->line('Proposal') . ': </br></br><small>' . $invoice['proposal'] ?></small>
                    </td>
                    <td><strong><?php echo $this->lang->line('Summary') ?>:</strong></td>
                    <td></td>


                </tr>
                <tr>


                    <td><?php echo $this->lang->line('SubTotal') ?>:</td>

                    <td><strong><?php echo amountExchange($sub_t, $invoice['multi']); ?></strong></td>
                </tr>
                <?php if ($invoice['tax'] > 0) {
                    echo '<tr>        

            <td> ' . $this->lang->line('Total Tax') . ' :</td>

            <td><strong>' . amountExchange($invoice['tax'], $invoice['multi']) . '</strong></td>
        </tr>';
                }

                if ($invoice['discount'] > 0) {
                    echo '<tr>


            <td>' . $this->lang->line('Total Discount') . ':</td>

            <td><strong>' . amountExchange($invoice['discount'], $invoice['multi']) . '</strong></td>
        </tr>';
                }
                if ($invoice['shipping'] > 0) {
                    echo '<tr>


            <td>' . $this->lang->line('Shipping') . ':</td>

            <td><strong>' . amountExchange($invoice['shipping'], $invoice['multi']) . '</strong></td>
        </tr>';
                }

                ?>
                <tr>


                    <td><?php echo $this->lang->line('Total') ?> :</td>

                    <td><strong><?php
                                echo amountExchange($invoice['total'], $invoice['multi']);
                                echo '</strong></td>
		</tr></tbody>
		</table><div class="sign">Authorized person</div><div class="sign1"><img src="' . FCPATH . 'userfiles/employee_sign/' . $employee['sign'] . '" width="160" height="50" border="0" alt=""></div><div class="sign2">(' . $employee['name'] . ')</div><div class="sign3">' . user_role($employee['roleid']) . '</div> <br><div class="terms">' . $invoice['notes'] . '<hr><strong>' . $this->lang->line('Terms') . ':</strong><br>';

                                echo '<strong>' . $invoice['termtit'] . '</strong><br>' . $invoice['terms'];
                                ?>
    </div>
    </div>
</body>

</html>