<div class="app-content content container-fluid">
    <div class="content-wrapper">
        <div id="notify" class="alert alert-success" style="display:none;">
            <a href="#" class="close" data-dismiss="alert">&times;</a>
            <div class="message"></div>
        </div>
        <div class="content-body">
            <section class="card">
                <div id="invoice-template" class="card-block">
                    <div class="row wrapper white-bg page-heading">

                        <div class="col-lg-12">
                            <?php
                            $validtoken = hash_hmac('ripemd160', 'q' . $invoice['tid'], $this->config->item('encryption_key'));

                            $link = base_url('billing/quoteview?id=' . $invoice['tid'] . '&token=' . $validtoken);
                            ?>
                            <div class="title-action">

                                <a href="<?php echo 'edit?id=' . $invoice['tid']; ?>" class="btn btn-warning mb-1"><i class="icon-pencil"></i> <?php echo $this->lang->line('Edit Quote') ?> </a>

                                <a href="#pop_model" data-toggle="modal" data-remote="false" class="btn btn-large btn-success mb-1" title="Change Status"><span class="icon-tab"></span> <?php echo $this->lang->line('Change Status') ?> </a>

                                <a href="#pop_model2" data-toggle="modal" data-remote="false" class="btn btn-large btn-info mb-1" title="onvert to Invoice"><span class="icon-share2"></span> <?php echo $this->lang->line('Convert to Invoice') ?>
                                </a>

                                <div class="btn-group">
                                    <button type="button" class="btn btn-primary dropdown-toggle mb-1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <span class="icon-envelope-o"></span> <?php echo $this->lang->line('Email') ?>
                                    </button>
                                    <div class="dropdown-menu"><a href="#sendEmail" data-toggle="modal" data-remote="false" class="dropdown-item sendbill" data-type="quote"><?php echo $this->lang->line('Send Proposal') ?></a>


                                    </div>

                                </div>

                                <div class="btn-group">
                                    <button type="button" class="btn btn-blue dropdown-toggle mb-1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <span class="icon-envelope-o"></span><?php echo $this->lang->line('SMS') ?>
                                    </button>
                                    <div class="dropdown-menu"><a href="#sendSMS" data-toggle="modal" data-remote="false" class="dropdown-item sendsms" data-type="quote"><?php echo $this->lang->line('Send Proposal') ?></a>


                                    </div>

                                </div>

                                <div class="btn-group ">
                                    <button type="button" class="btn btn-success btn-min-width dropdown-toggle mb-1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="icon-print"></i> <?php echo $this->lang->line('Print Quote') ?>
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="<?php echo 'printquote?id=' . $invoice['tid']; ?>"><?php echo $this->lang->line('Print') ?></a>
                                        <div class="dropdown-divider"></div>
                                        <a class="dropdown-item" href="<?php echo 'printquote?id=' . $invoice['tid']; ?>&d=1"><?php echo $this->lang->line('PDF Download') ?></a>

                                    </div>
                                </div>
                                <a href="<?php echo $link; ?>" class="btn btn-primary mb-1"><i class="icon-earth"></i> <?php echo $this->lang->line('Preview') ?>
                                </a>


                            </div>
                        </div>
                    </div>

                    <?php if ($invoice['multi'] > 0) {

                        echo '<div class="tag tag-info text-xs-center mt-2">' . $this->lang->line('Payment currency is different') . '</div>';
                    }
                    ?>
                    <div class="col-md-12">
                        <p></p>
                        <img src="<?php echo base_url('userfiles/company/' . $this->config->item('logo')) ?>" class="img-responsive p-1 m-b-2" style="max-height: 120px;">
                    </div>
                    <!-- Invoice Company Details -->
                    <div class="col-md-4">
                        <p class="text-bold-800"><?php echo $this->lang->line('From') . ': ' . $this->config->item('ctitle') ?></p>
                        <ul class="px-0 list-unstyled">

                            <?php if ($this->config->item('country')) echo '<p>' . $this->lang->line('Country') . ':' . $this->config->item('country') . ' - '  ?>
                            <?php if ($this->config->item('region')) echo  $this->lang->line('Region') . ':' . $this->config->item('region') . ' - '  ?>
                            <?php if ($this->config->item('city')) echo $this->lang->line('City') . ':' . $this->config->item('city') . '' . '</p>' ?>
                            <?php if ($this->config->item('address')) echo '<p>' . $this->lang->line('Address') . ':' . $this->config->item('address') . ' ' . '</p>' ?>
                            <?php if ($this->config->item('postbox')) echo '<p>' . $this->lang->line('Postbox') . ':' .  $this->config->item('postbox') . ' ' . '</p>' ?>
                            <?php if ($this->config->item('phone')) echo '<p>' . $this->lang->line('Phone') . ':' . $this->config->item('phone')  . ' ' . '</p>' ?>
                            <?php if ($this->config->item('email')) echo '<p>' . $this->lang->line('Email') . ':' .  $this->config->item('email') . ' ' . '</p>' ?>
                            </li>
                        </ul>
                    </div>

                    <!--/ Invoice Company Details -->


                    <!-- Invoice Customer Details -->
                    <div class="col-md-4">
                        <ul class="px-0 list-unstyled">
                            <p class="text-muted"><?php echo $this->lang->line('Bill To') ?></p>

                            <li class="text-bold-600"><a href="<?php echo base_url('customers/view?id=' . $invoice['cid']) ?>"><strong class="invoice_a"><?php echo $invoice['name'] . '</strong></a></li>'; ?>
                                        <?php if ($invoice['company']) echo '<p>' . $this->lang->line('Company') . ':' . $invoice['company'] . ' ' . '</p>' ?>
                                        <?php if ($invoice['country']) echo '<p>' . $this->lang->line('Country') . ':' . $invoice['country'] . ' - '  ?>
                                        <?php if ($invoice['region']) echo  $this->lang->line('Region') . ':' . $invoice['region'] . ' - '  ?>
                                        <?php if ($invoice['city']) echo $this->lang->line('City') . ':' . $invoice['city'] . '' . '</p>' ?>
                                        <?php if ($invoice['address']) echo '<p>' . $this->lang->line('Address') . ':' . $invoice['address'] . ' ' . '</p>' ?>
                                        <?php if ($invoice['postbox']) echo '<p>' . $this->lang->line('Postbox') . ':' . $invoice['postbox'] . ' ' . '</p>' ?>
                                        <?php if ($invoice['phone']) echo '<p>' . $this->lang->line('Phone') . ':' . $invoice['phone'] . ' ' . '</p>' ?>
                                        <?php if ($invoice['email']) echo '<p>' . $this->lang->line('Email') . ':' . $invoice['email'] . ' ' . '</p>' ?>
                                        <?php if ($invoice['taxid']) echo '<p>' . $this->lang->line('TAX ID') . ':' . $invoice['taxid'] . ' ' . '</p>' ?>
                            </li>
                        </ul>

                    </div>
                    <div class="col-md-4">
                        <h2><?php echo $this->lang->line('Quote') . ': ' . prefix(1) . $invoice['tid'] ?></h2>
                        <?php echo '<p><span class="text-muted">' . $this->lang->line('Reference') . ' :</span> ' . $invoice['refer'] . '</p>'; ?>
                        <ul class="px-0 list-unstyled">
                            <li><?php echo $this->lang->line('Gross Amount') . ':' . amountFormat($invoice['total']) ?></li>
                        </ul>
                        <?php echo '<p><span class="text-muted">' . $this->lang->line('Quote Date') . ' :</span> ' . $this->jdf->s_gregorian_to_jalali($invoice['invoicedate']) . '</p>'; ?>
                        <?php echo  '</p> <p><span class="text-muted">' . $this->lang->line('Due Date') . ' :</span> ' . $this->jdf->s_gregorian_to_jalali($invoice['invoiceduedate']) . '</p>'; ?>
                    </div>
                </div>
                <hr>
                <!--/ Invoice Customer Details -->

                <?php if ($invoice['proposal'] != '') {
                    echo '<div id="invoice-customer-details" class="row pt-2">
                        <div class="col-sm-12 text-xs-center text-md-left">';

                    echo '<h5>' . $this->lang->line('Proposal') . '</h5>';
                    echo '<p>' . $invoice['proposal'] . '</p>';


                    echo '   </div></div>';
                } ?>
                <!-- Invoice Items Details -->
                <div id="invoice-items-details" class="pt-2">
                    <div class="row">
                        <div class="table-responsive col-sm-12">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo $this->lang->line('Description') ?></th>
                                        <th class="text-xs-left"><?php echo $this->lang->line('Rate') ?></th>
                                        <th class="text-xs-left"><?php echo $this->lang->line('Qty') ?></th>
                                        <th class="text-xs-left"><?php echo $this->lang->line('Tax') ?></th>
                                        <th class="text-xs-left"><?php echo $this->lang->line('Discount') ?></th>
                                        <th class="text-xs-left"><?php echo $this->lang->line('Amount') ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $c = 1;
                                    $sub_t = 0;
                                    foreach ($products as $row) {
                                        $sub_t += $row['price'] * $row['qty'];
                                        echo '<tr>
<th scope="row">' . $c . '</th>
                            <td>' . $row['product'] . '</td>
                           
                            <td>' . amountFormat($row['price']) . '</td>
                             <td>' . $row['qty'] . '</td>
                            <td>' . amountFormat($row['totaltax']) . ' (' . amountFormat_s($row['tax']) . '%)</td>
                            <td>' . amountFormat($row['totaldiscount']) . '(' . amountFormat_s($row['discount']) . $this->lang->line($invoice['format_discount']) . ')</td>
                            <td>' . amountFormat($row['subtotal']) . '</td>
                        </tr>';
                                        echo '<tr><td colspan=5>' . $row['product_des'] . '</td></tr>';
                                        $c++;
                                    } ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                    <p></p>
                    <br>
                    <div class="row">
                        <div class="col-md-7 col-sm-12 text-xs-center text-md-left">


                            <div class="row">
                                <div class="col-md-8 ml-2">

                                    <p class="lead"><?php echo $this->lang->line('Status') ?>: <u><strong id="pstatus"><?php echo $this->lang->line(ucwords($invoice['status'])) ?></strong></u>
                                    </p>
                                    <p class="lead mt-1"><br><?php echo $this->lang->line('Note') ?>:</p>
                                    <code>
                                        <?php echo $invoice['notes'] ?>
                                    </code>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5 col-sm-12">
                            <p class="lead"><?php echo $this->lang->line('Total Due') ?></p>
                            <div class="table-responsive">
                                <table class="table">
                                    <tbody>
                                        <tr>
                                            <td><?php echo $this->lang->line('Sub Total') ?></td>
                                            <td class="text-xs-right"> <?php echo amountFormat($sub_t) ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo $this->lang->line('Discount') ?></td>
                                            <td class="text-xs-right"><?php echo amountFormat($invoice['discount']) ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo $this->lang->line('TAX') ?></td>
                                            <td class="text-xs-right"><?php echo amountFormat($invoice['tax']) ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo $this->lang->line('Shipping') ?></td>
                                            <td class="text-xs-right"><?php echo amountFormat($invoice['shipping']) ?></td>
                                        </tr>


                                        <tr class="bg-grey bg-lighten-4">
                                            <td class="text-bold-800"><?php echo $this->lang->line('Total') ?></td>
                                            <td class="text-bold-800 text-xs-right"> <?php

                                                                                        echo ' <span id="paydue">' . amountFormat($invoice['total']) . '</span></strong>'; ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="text-xs-center">
                                <p><?php echo $this->lang->line('Authorized person') ?></p>
                                <?php echo '<img src="' .  base_url()  . 'userfiles/employee_sign/' . $employee['sign'] . '" alt="signature" class="height-100"/>
                                    <h6>(' . $employee['name'] . ')</h6>
                                    <p class="text-muted">' . user_role($employee['roleid']) . '</p>'; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Invoice Footer -->

                <div id="invoice-footer">


                    <div class="row">

                        <div class="col-md-7 col-sm-12">

                            <h6><?php echo $this->lang->line('Terms & Condition') ?></h6>
                            <p> <?php

                                echo '<strong>' . $invoice['termtit']  . '</strong>' . ' ' . $invoice['terms'];
                                ?></p>
                        </div>

                    </div>

                </div>
                <!--/ Invoice Footer -->
                <hr>
                <pre><?php echo $this->lang->line('Public Access URL') ?>:<a href="<?php
                                                                                    echo $link ?> " target="_blank"><?php
                                                                                                                    echo $link ?></a> </pre>
                <pre>این لینک را می توانید در شبکه های اجتماعی برای مشتری ارسال نمایید تا نسبت به پرداخت آن اقدام نمایند. </pre>
                <div class="row">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th><?php echo $this->lang->line('Files') ?></th>


                            </tr>
                        </thead>
                        <tbody id="activity">
                            <?php foreach ($attach as $row) {

                                echo '<tr><td><a data-url="' . base_url() . 'quote/file_handling?op=delete&name=' . $row['col1'] . '&invoice=' . $invoice['tid'] . '" class="aj_delete"><i class="btn-danger btn-lg icon-trash-a"></i></a> <a class="n_item" href="' . base_url() . 'userfiles/attach/' . $row['col1'] . '"> ' . $row['col1'] . ' </a></td></tr>';
                            } ?>

                        </tbody>
                    </table>

                    <!-- The fileinput-button span is used to style the file input field as button -->
                    <span class="btn btn-success fileinput-button">
                        <i class="glyphicon glyphicon-plus"></i>
                        <span><?php echo $this->lang->line('Select files...') ?></span>
                        <!-- The file input field used as target for the file upload widget -->
                        <input id="fileupload" type="file" name="files[]" multiple>
                    </span>
                    <br>
                    <pre><?php echo $this->lang->line('Allowed') ?>: gif, jpeg, png, docx, docs, txt, pdf, xls </pre>
                    <br>
                    <!-- The global progress bar -->
                    <div id="progress" class="progress">
                        <div class="progress-bar progress-bar-success"></div>
                    </div>
                    <!-- The container for the uploaded files -->
                    <table id="files" class="files"></table>
                    <br>
                </div>
        </div>
        </section>
    </div>
</div>
</div>


<!-- Modal HTML -->

<div id="pop_model" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title"><?php echo $this->lang->line('Change Status') ?></h4>
            </div>

            <div class="modal-body">
                <form id="form_model">


                    <div class="row">
                        <div class="col-xs-12 mb-1"><label for="pmethod"><?php echo $this->lang->line('Mark As') ?></label>
                            <select name="status" class="form-control mb-1">
                                <option value="pending"><?php echo $this->lang->line('Pending') ?></option>
                                <option value="accepted"><?php echo $this->lang->line('Accepted') ?></option>
                                <option value="rejected"><?php echo $this->lang->line('Rejected') ?></option>
                            </select>

                        </div>
                    </div>

                    <div class="modal-footer">
                        <input type="hidden" class="form-control required" name="tid" id="invoiceid" value="<?php echo $invoice['tid'] ?>">
                        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo $this->lang->line('Close') ?></button>
                        <input type="hidden" id="action-url" value="quote/update_status">
                        <button type="button" class="btn btn-primary" id="submit_model"><?php echo $this->lang->line('Change Status') ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div id="pop_model2" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title"><?php echo $this->lang->line('Change Status') ?></h4>
            </div>

            <div class="modal-body">
                <form id="form_model2">


                    <div class="row">
                        <div class="col-xs-12 mb-1"><?php echo $this->lang->line('quote as invoice') ?>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <input type="hidden" class="form-control required" name="tid" id="invoiceid" value="<?php echo $invoice['tid'] ?>">
                        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo $this->lang->line('Close') ?></button>
                        <input type="hidden" id="action-url" value="quote/convert">
                        <button type="button" class="btn btn-primary" id="submit_model2"><?php echo $this->lang->line('Yes') ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


<!-- Modal HTML -->
<div id="sendEmail" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title">Email</h4>
            </div>
            <div id="request">
                <div id="ballsWaveG">
                    <div id="ballsWaveG_1" class="ballsWaveG"></div>
                    <div id="ballsWaveG_2" class="ballsWaveG"></div>
                    <div id="ballsWaveG_3" class="ballsWaveG"></div>
                    <div id="ballsWaveG_4" class="ballsWaveG"></div>
                    <div id="ballsWaveG_5" class="ballsWaveG"></div>
                    <div id="ballsWaveG_6" class="ballsWaveG"></div>
                    <div id="ballsWaveG_7" class="ballsWaveG"></div>
                    <div id="ballsWaveG_8" class="ballsWaveG"></div>
                </div>
            </div>
            <div class="modal-body" id="emailbody" style="display: none;">
                <form id="sendbill">
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="input-group">
                                <div class="input-group-addon"><span class="icon-envelope-o" aria-hidden="true"></span></div>
                                <input type="text" class="form-control" placeholder="Email" name="mailtoc" value="<?php echo $invoice['email'] ?>">
                            </div>

                        </div>

                    </div>


                    <div class="row">
                        <div class="col-xs-12 mb-1"><label for="shortnote"><?php echo $this->lang->line('Customer Name') ?></label>
                            <input type="text" class="form-control" name="customername" value="<?php echo $invoice['name'] ?>">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 mb-1"><label for="shortnote"><?php echo $this->lang->line('Subject') ?></label>
                            <input type="text" class="form-control" name="subject" id="subject">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 mb-1"><label for="shortnote"><?php echo $this->lang->line('Message') ?></label>
                            <textarea name="text" class="summernote" id="contents" title="Contents"></textarea>
                        </div>
                    </div>

                    <input type="hidden" class="form-control" id="invoiceid" name="tid" value="<?php echo $invoice['tid'] ?>">
                    <input type="hidden" class="form-control" id="emailtype" value="">


                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo $this->lang->line('Close') ?></button>
                <button type="button" class="btn btn-primary" id="sendM"><?php echo $this->lang->line('Send') ?></button>
            </div>
        </div>
    </div>
</div>
<!--sms-->
<!-- Modal HTML -->
<div id="sendSMS" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title"><?php echo $this->lang->line('Send'); ?> SMS</h4>
            </div>
            <div id="request_sms">
                <div id="ballsWaveG1">
                    <div id="ballsWaveG_1" class="ballsWaveG"></div>
                    <div id="ballsWaveG_2" class="ballsWaveG"></div>
                    <div id="ballsWaveG_3" class="ballsWaveG"></div>
                    <div id="ballsWaveG_4" class="ballsWaveG"></div>
                    <div id="ballsWaveG_5" class="ballsWaveG"></div>
                    <div id="ballsWaveG_6" class="ballsWaveG"></div>
                    <div id="ballsWaveG_7" class="ballsWaveG"></div>
                    <div id="ballsWaveG_8" class="ballsWaveG"></div>
                </div>
            </div>
            <div class="modal-body" id="smsbody" style="display: none;">
                <form id="sendsms">
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="input-group">
                                <div class="input-group-addon"><span class="icon-envelope-o" aria-hidden="true"></span></div>
                                <input type="text" class="form-control" placeholder="SMS" name="mobile" value="<?php echo $invoice['phone'] ?>">
                            </div>

                        </div>

                    </div>


                    <div class="row">
                        <div class="col-xs-12 mb-1"><label for="shortnote"><?php echo $this->lang->line('Customer Name'); ?></label>
                            <input type="text" class="form-control" value="<?php echo $invoice['name'] ?>">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-xs-12 mb-1"><label for="shortnote"><?php echo $this->lang->line('Message'); ?></label>
                            <textarea class="form-control" name="text_message" id="sms_tem" title="Contents" rows="3"></textarea>
                        </div>
                    </div>


                    <input type="hidden" class="form-control" id="smstype" value="">


                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo $this->lang->line('Close'); ?></button>
                <button type="button" class="btn btn-primary" id="submitSMS"><?php echo $this->lang->line('Send'); ?></button>
            </div>
        </div>
    </div>
</div>
<script src="<?php echo base_url('assets/myjs/jquery.ui.widget.js') ?>"></script>
<script src="<?php echo base_url('assets/myjs/jquery.fileupload.js') ?>"></script>
<script>
    /*jslint unparam: true */
    /*global window, $ */
    $(function() {
        'use strict';
        // Change this to the location of your server-side upload handler:
        var url = '<?php echo base_url() ?>quote/file_handling?id=<?php echo $invoice['tid'] ?>';
        $('#fileupload').fileupload({
                url: url,
                dataType: 'json',
                done: function(e, data) {
                    $.each(data.result.files, function(index, file) {
                        $('#files').append('<tr><td><a data-url="<?php echo base_url() ?>quote/file_handling?op=delete&name=' + file.name + '&invoice=<?php echo $invoice['tid'] ?>" class="aj_delete"><i class="btn-danger btn-sm icon-trash-a"></i> ' + file.name + ' </a></td></tr>');

                    });
                },
                progressall: function(e, data) {
                    var progress = parseInt(data.loaded / data.total * 100, 10);
                    $('#progress .progress-bar').css(
                        'width',
                        progress + '%'
                    );
                }
            }).prop('disabled', !$.support.fileInput)
            .parent().addClass($.support.fileInput ? undefined : 'disabled');
    });

    $(document).on('click', ".aj_delete", function(e) {
        e.preventDefault();

        var aurl = $(this).attr('data-url');
        var obj = $(this);

        jQuery.ajax({

            url: aurl,
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                obj.closest('tr').remove();
                obj.remove();
            }
        });

    });
</script>
<script type="text/javascript">
    $(function() {
        $('.summernote').summernote({
            height: 100,
            toolbar: [
                // [groupName, [list of button]]
                ['style', ['bold', 'italic', 'underline', 'clear']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['fontsize', ['fontsize']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']],
                ['fullscreen', ['fullscreen']],
                ['codeview', ['codeview']]
            ]
        });

        $('#sendM').on('click', function(e) {
            e.preventDefault();

            sendBill($('.summernote').summernote('code'));

        });
    });
</script>