<div class="app-content content container-fluid">
    <div class="content-wrapper">
        <div id="notify" class="alert alert-success" style="display:none;">
            <a href="#" class="close" data-dismiss="alert">&times;</a>
            <div class="message"></div>
        </div>
        <div class="content-body">
            <section class="card">
                <div id="invoice-template" class="card-block">
                    <div class="row wrapper white-bg page-heading">

                        <div class="col-lg-12">
                            <?php
                            $validtoken = hash_hmac('ripemd160', 'rec' . $invoice['tid'], $this->config->item('encryption_key'));

                            $link = base_url('billing/invoice?id=' . $invoice['tid'] . '&token=' . $validtoken);
                            if ($invoice['status'] != 'canceled') { ?>
                                <div class="title-action">

                                    <a href="<?php echo 'edit?id=' . $invoice['tid']; ?>" class="btn btn-warning"><i class="icon-pencil"></i> <?php echo $this->lang->line('Edit Invoice') ?>
                                    </a>

                                    <a href="#part_payment" data-toggle="modal" data-remote="false" data-type="reminder" class="btn btn-large btn-success" title="Partial Payment"><span class="icon-money"></span> <?php echo $this->lang->line('Make Payment') ?> </a>

                                    <div class="btn-group">
                                        <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            <span class="icon-envelope-o"></span> <?php echo $this->lang->line('Send') ?>
                                        </button>
                                        <div class="dropdown-menu"><a href="#sendEmail" data-toggle="modal" data-remote="false" class="dropdown-item sendbill" data-type="notification" data-itype="rec"><?php echo $this->lang->line('Invoice Notification') ?></a>
                                            <div class="dropdown-divider"></div>
                                            <a href="#sendEmail" data-toggle="modal" data-remote="false" class="dropdown-item sendbill" data-type="reminder" data-itype="rec"><?php echo $this->lang->line('Payment Reminder') ?></a>
                                            <a href="#sendEmail" data-toggle="modal" data-remote="false" class="dropdown-item sendbill" data-type="received" data-itype="rec"><?php echo $this->lang->line('Payment Received') ?></a>
                                            <div class="dropdown-divider"></div>
                                            <a href="#sendEmail" data-toggle="modal" data-remote="false" class="dropdown-item sendbill" href="#" data-type="overdue" data-itype="rec"><?php echo $this->lang->line('Payment Overdue') ?></a><a href="#sendEmail" data-toggle="modal" data-remote="false" class="dropdown-item sendbill" data-type="refund" data-itype="rec"><?php echo $this->lang->line('Refund Generated') ?></a>

                                        </div>

                                    </div>
                                    <!-- SMS -->
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-blue dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            <span class="icon-envelope-o"></span><?php echo $this->lang->line('SMS') ?>
                                        </button>
                                        <div class="dropdown-menu"><a href="#sendSMS" data-toggle="modal" data-remote="false" class="dropdown-item sendsms" data-type="notification-rec"><?php echo $this->lang->line('Invoice Notification') ?></a>
                                            <div class="dropdown-divider"></div>
                                            <a href="#sendSMS" data-toggle="modal" data-remote="false" class="dropdown-item sendsms" data-type="reminder-rec"><?php echo $this->lang->line('Payment Reminder') ?></a>
                                            <a href="#sendSMS" data-toggle="modal" data-remote="false" class="dropdown-item sendsms" data-type="received-rec"><?php echo $this->lang->line('Payment Received') ?></a>
                                            <div class="dropdown-divider"></div>
                                            <a href="#sendSMS" data-toggle="modal" data-remote="false" class="dropdown-item sendsms" href="#" data-type="overdue-rec"><?php echo $this->lang->line('Payment Overdue') ?></a><a href="#sendSMS" data-toggle="modal" data-remote="false" class="dropdown-item sendbill" data-type="refund"><?php echo $this->lang->line('Refund Generated') ?></a>

                                        </div>
                                    </div>
                                    <!-- End SMS -->
                                    <div class="btn-group ">
                                        <button type="button" class="btn btn-success btn-min-width dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="icon-print"></i> <?php echo $this->lang->line('Print') ?>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="<?php echo 'printinvoice?id=' . $invoice['tid']; ?>"><?php echo $this->lang->line('Print') ?></a>
                                            <div class="dropdown-divider"></div>
                                            <a class="dropdown-item" href="<?php echo 'printinvoice?id=' . $invoice['tid']; ?>&d=1"><?php echo $this->lang->line('PDF Download') ?></a>

                                        </div>
                                    </div>
                                    <a href="<?php echo $link; ?>" class="btn btn-primary"><i class="icon-earth"></i> <?php echo $this->lang->line('Preview') ?></a>

                                    <a href="#pop_model" data-toggle="modal" data-remote="false" class="btn btn-large btn-success" title="Change Pay Status"><span class="icon-ticket"></span> <?php echo $this->lang->line('Mark As') ?></a>

                                    <a href="#pop_model2" data-toggle="modal" data-remote="false" class="btn btn-large btn-orange" title="Change Status"><span class="icon-tab"></span> <?php echo $this->lang->line('Recurring') ?> </a>
                                    <a href="#cancel-bill" class="btn btn-danger" id="cancel-bill_rec"><i class="icon-minus-circle"> </i> <?php echo $this->lang->line('Cancel') ?>
                                    </a>




                                </div><?php } else {
                                        echo '<h2 class="btn btn-oval btn-danger">' . $this->lang->line('Cancelled') . '</h2>';
                                    } ?>
                        </div>
                    </div>
                    <br>
                    <br>
                    <!-- start new section -->
                    <div class="panel-body">
                        <!-- <div class="invoice-ribbon">
                            <div class="ribbon-inner"><?php echo $this->lang->line(ucwords($invoice['status'])) ?></div>
                        </div> -->
                        <div class="row">
                            <div class="col-sm-6 top-left">
                                <img src="<?php echo base_url('userfiles/company/' . $this->config->item('logo')) ?>" class="img-responsive p-1 m-b-2" style="max-height: 120px;">
                            </div>
                            <?php $status = ucwords($invoice['status']);
                            if ($status == "Paid") {
                                $class = "st-paid";
                            } else {
                                $class = "st-due";
                            }
                            ?>
                            <div class="col-sm-6 top-right" style="text-align: center;">
                                <p class="marginright lead"> <?php echo $this->lang->line('RECCURING INVOICE') . ':' . prefix(3) . $invoice['tid'] ?></p>
                                <p class="marginright lead"><?php echo   $this->lang->line('Due Date') . ': ' . $this->jdf->s_gregorian_to_jalali($invoice['invoiceduedate']) ?> </p>
                                <p class="marginright lead"><?php echo   $this->lang->line('Payment Status') . ': ' . '<strong class=" ' .  $class  . '">' . $this->lang->line(ucwords($invoice['status'])) . '</strong>' ?> </p>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <!-- Invoice Company Details -->
                            <div class="col-xs-4 to">
                                <p class="lead marginbottom"><?php echo $this->lang->line('From') . ' :' . $this->config->item('ctitle'); ?></p>

                                <?php echo '<p>' . $this->config->item('country') . ' ' .
                                    $this->config->item('region') . ' '  . ' ' . $this->config->item('city') . ' ' . $this->config->item('address') . ' </p><p>' .  $this->config->item('postbox') . ' </p>' . $this->lang->line('Phone') . ' : ' . $this->config->item('phone') . '</p><p> ' . $this->lang->line('Email') . ' : ' . $this->config->item('email'); ?>
                                </p>
                            </div>
                            <!-- / Invoice Company Details -->

                            <!-- Invoice Customer Details -->
                            <div class="col-xs-4 to">
                                <p class="lead marginbottom"><?php echo $this->lang->line('Bill To') . ' :' . '<a href=' . base_url('customers/view?id=' . $invoice['cid']) . '>' . $invoice['name'] . '</a>'; ?></p>

                                <?php echo '<p>' .  $invoice['country'] . ' ' .
                                    $invoice['region'] . ' '  .  $invoice['city'] . ' ' .  $invoice['address'] . ' </p><p>' .   $invoice['postbox'] . ' </p>' . $this->lang->line('Phone') . ' : ' .  $invoice['phone'] . '</p><p> ' . $this->lang->line('Email') . ' : ' .  $invoice['email'] . '</p><p> ' .  $invoice['taxid'] . '</p>'; ?>
                                </p>
                            </div>
                            <!-- / Invoice Customer Details -->

                            <!-- Invoice Items Details -->
                            <div class="col-xs-4 text-right payment-details">
                                <p class="lead marginbottom payment-info">جزئیات پرداخت</p>
                                <p class=""><?php echo  $this->lang->line('Invoice Date') . ': ' . $this->jdf->s_gregorian_to_jalali($invoice['invoicedate']) ?> </p>
                                <p><?php echo $this->lang->line('Reference') . ':' . $invoice['refer']; ?></p>
                                <p><?php echo $this->lang->line('Gross Amount') . ':' . amountExchange($invoice['total'], $invoice['multi']) ?> </p>
                                <p></p>
                                <td class="text-bold-800 text-xs-right"><strong> <?php $myp = '';
                                                                                    $rming = $invoice['total'] - $invoice['pamnt'];
                                                                                    if ($rming < 0) {
                                                                                        $rming = 0;
                                                                                    }
                                                                                    echo ' <span class="badge badge-warning">' . $this->lang->line('Balance Due') . ': ' . amountFormat($rming) . '</span></strong>'; ?></td>
                                <p></p>
                                <td class="text-bold-800 text-xs-right"><strong> <?php echo ' <span class="badge badge-warning">' . $this->lang->line('Reccuring Period') . ': ' . $this->lang->line(ucwords($invoice['rec'])) . '</span></strong>'; ?></td>
                            </div>
                            <!--/ Invoice Items Details -->


                        </div>

                        <!-- haml and lagl -->
                        <div class="row"> <?php if ($invoice['name_s']) { ?>
                                <hr>
                                <div class="col-xs-12 to">
                                    <p class="lead marginbottom"><?php echo $this->lang->line('Shipping Address') ?></p>
                                    <p> <?php echo $invoice['country_s'] . ' ' . $invoice['region_s'] . ' ' . $invoice['city_s'] . ' ' . $invoice['address_s'] . $invoice['postbox_s'] . '<br><br><strong>' . $this->lang->line('Phone') . ' : ' . $invoice['phone_s'] . '</strong><strong>' . $this->lang->line('Email') . ' : ' . $invoice['email_s'];  ?></strong>
                                </div>
                            <?php } ?>
                        </div>
                        <!-- haml and lagl -->
                    </div>
                    <!-- End new section -->
                    <!-- Invoice Items Details -->
                    <div id="invoice-items-details" class="pt-2">
                        <div class="row">
                            <div class="table-responsive col-sm-12">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th><?php echo $this->lang->line('Description') ?></th>
                                            <th class="text-xs-left"><?php echo $this->lang->line('Rate') ?></th>
                                            <th class="text-xs-left"><?php echo $this->lang->line('Qty') ?></th>
                                            <th class="text-xs-left"><?php echo $this->lang->line('Tax') ?></th>
                                            <th class="text-xs-left"><?php echo $this->lang->line('Discount') ?></th>
                                            <th class="text-xs-left"><?php echo $this->lang->line('Amount') ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $c = 1;
                                        $sub_t = 0;
                                        foreach ($products as $row) {
                                            $sub_t += $row['price'] * $row['qty'];

                                            echo '<tr>
                            <th scope="row">' . $c . '</th>
                            <td>' . $row['product'] . '</td>
                           
                            <td>' . amountFormat($row['price']) . '</td>
                             <td>' . $row['qty'] . '</td>
                            <td>' . amountFormat($row['totaltax']) . ' (' . amountFormat_s($row['tax']) . '%)</td>
                            <td>' . amountFormat($row['totaldiscount']) . '(' . amountFormat_s($row['discount']) . $this->lang->line($invoice['format_discount']) . ')</td>
                            <td>' . amountFormat($row['subtotal']) . '</td>
                        </tr>';
                                            echo '<tr><td colspan=5>' . $row['product_des'] . '</td></tr>';
                                            $c++;
                                        } ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <p></p>
                        <div class="row">
                            <div class="col-md-7 col-sm-12 text-xs-center text-md-left">


                                <div class="row">
                                    <div class="col-md-8">
                                        <p class="lead"><?php echo $this->lang->line('Payment Status') ?>:
                                            <span><strong id="pstatus" class="<?php echo $class ?> "><?php echo $this->lang->line(ucwords($invoice['status'])) ?></strong></span>
                                        </p>
                                        <p class="lead"><?php echo $this->lang->line('Invoice Status') ?>: <u><strong id="pstatus"><?php echo  $this->lang->line(strtoupper($invoice['ron'])) ?></strong></u>
                                        </p>
                                        <p class="lead"><?php echo $this->lang->line('Payment Method') ?>: <u><strong id="pmethod"><?php echo $this->lang->line($invoice['pmethod']) ?></strong></u>
                                        </p>

                                        <p class="lead mt-1"><br><?php echo $this->lang->line('Note') ?>:</p>
                                        <code>
                                            <?php echo $invoice['notes'] ?>
                                        </code>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-5 col-sm-12">
                                <p class="lead"><?php echo $this->lang->line('Total Due') ?></p>
                                <div class="table-responsive">
                                    <table class="table">
                                        <tbody>
                                            <tr>
                                                <td><?php echo $this->lang->line('Sub Total') ?></td>
                                                <td class="text-xs-right"> <?php echo amountFormat($sub_t) ?></td>
                                            </tr>
                                            <tr>
                                                <td><?php echo $this->lang->line('TAX') ?></td>
                                                <td class="text-xs-right"><?php echo amountFormat($invoice['tax']) ?></td>
                                            </tr>
                                            <tr>
                                            <tr>
                                                <td><?php echo $this->lang->line('Discount') ?></td>
                                                <td class="text-xs-right"><?php echo amountExchange($invoice['discount'], $invoice['multi']) ?></td>
                                            </tr>
                                            <td><?php echo $this->lang->line('Shipping') ?></td>
                                            <td class="text-xs-right"><?php echo amountFormat($invoice['shipping']) ?></td>
                                            </tr>
                                            <tr>
                                                <td class="text-bold-800"><?php echo $this->lang->line('Total') ?></td>
                                                <td class="text-bold-800 text-xs-right"> <?php echo amountFormat($invoice['total']) ?></td>
                                            </tr>
                                            <tr>
                                                <td><?php echo $this->lang->line('Payment Made') ?></td>
                                                <td class="pink text-xs-right">
                                                    (-) <?php echo ' <span id="paymade">' . amountFormat($invoice['pamnt']) ?></span></td>
                                            </tr>
                                            <tr class="bg-grey bg-lighten-4">
                                                <td class="text-bold-800"><?php echo $this->lang->line('Balance Due') ?></td>
                                                <td class="text-bold-800 text-xs-right"> <?php $myp = '';
                                                                                            $rming = $invoice['total'] - $invoice['pamnt'];
                                                                                            if ($rming < 0) {
                                                                                                $rming = 0;
                                                                                            }
                                                                                            echo ' <span id="paydue">' . amountFormat($rming) . '</span></strong>'; ?></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="text-xs-center">
                                    <p><?php echo $this->lang->line('Authorized person') ?></p>
                                    <?php echo '<img src=' . base_url() . 'userfiles/employee_sign/' . $employee['sign'] . ' alt="signature" class="height-100"/>
                                    <h6>(' . $employee['name'] . ')</h6>
                                    <p class="text-muted">' . user_role($employee['roleid']) . '</p>'; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Invoice Footer -->

                    <div id="invoice-footer">
                        <p class="lead"><?php echo $this->lang->line('Credit Transactions') ?>:</p>
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th><?php echo $this->lang->line('Date') ?></th>
                                    <th><?php echo $this->lang->line('Method') ?></th>
                                    <th><?php echo $this->lang->line('Amount') ?></th>
                                    <th><?php echo $this->lang->line('Note') ?></th>


                                </tr>
                            </thead>
                            <tbody id="activity">
                                <?php foreach ($activity as $row) {

                                    echo '<tr>
                            <td>' . $this->jdf->s_gregorian_to_jalali($row['date']) . '</td>
                            <td>' .  $this->lang->line($row['method']) . '</td>
                            <td>' . amountFormat($row['credit']) . '</td>
                            <td>' . $row['note'] . '</td>
                        </tr>';
                                } ?>

                            </tbody>
                        </table>

                        <div class="row">

                            <div class="col-md-7 col-sm-12">

                                <h6><?php echo $this->lang->line('Terms & Condition') ?></h6>
                                <p> <?php

                                    echo '<strong>' . $invoice['termtit']  . '</strong>' . ' ' . $invoice['terms'];
                                    ?></p>
                            </div>

                        </div>

                    </div>
                    <!--/ Invoice Footer -->
                    <hr>
                    <pre><?php echo $this->lang->line('Public Access URL') ?>:<a href="<?php
                                                                                        echo $link ?> " target="_blank"><?php
                                                                                                                        echo $link ?></a> </pre>
                    <pre>این لینک را می توانید در شبکه های اجتماعی برای مشتری ارسال نمایید تا نسبت به پرداخت آن اقدام نمایند. </pre>
                    <div class="row">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th><?php echo $this->lang->line('Files') ?></th>


                                </tr>
                            </thead>
                            <tbody id="activity">
                                <?php foreach ($attach as $row) {

                                    echo '<tr><td><a data-url="' . base_url() . 'rec_invoices/file_handling?op=delete&name=' . $row['col1'] . '&invoice=' . $invoice['tid'] . '" class="aj_delete"><i class="btn-danger btn-lg icon-trash-a"></i></a> <a class="n_item" href="' . base_url() . 'userfiles/attach/' . $row['col1'] . '"> ' . $row['col1'] . ' </a></td></tr>';
                                } ?>

                            </tbody>
                        </table>
                        <!-- The fileinput-button span is used to style the file input field as button -->
                        <span class="btn btn-success fileinput-button">
                            <i class="glyphicon glyphicon-plus"></i>
                            <span><?php echo $this->lang->line('Select files...') ?></span>
                            <!-- The file input field used as target for the file upload widget -->

                            <input id="fileupload" type="file" name="files[]" multiple>
                        </span>
                        <br>
                        <br>
                        <pre><?php echo $this->lang->line('Allowed') ?>: gif, jpeg, png, docx, docs, txt, pdf, xls </pre>
                        <br>
                        <!-- The global progress bar -->
                        <div id="progress" class="progress">
                            <div class="progress-bar progress-bar-success"></div>
                        </div>
                        <!-- The container for the uploaded files -->
                        <table id="files" class="files"></table>
                        <br>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<script src="<?php echo base_url('assets/myjs/jquery.ui.widget.js') ?>"></script>
<script src="<?php echo base_url('assets/myjs/jquery.fileupload.js') ?>"></script>
<script>
    /*jslint unparam: true */
    /*global window, $ */
    $(function() {
        'use strict';
        // Change this to the location of your server-side upload handler:
        var url = '<?php echo base_url() ?>rec_invoices/file_handling?id=<?php echo $invoice['tid'] ?>';
        $('#fileupload').fileupload({
                url: url,
                dataType: 'json',
                done: function(e, data) {
                    $.each(data.result.files, function(index, file) {
                        $('#files').append('<tr><td><a data-url="<?php echo base_url() ?>rec_invoices/file_handling?op=delete&name=' + file.name + '&invoice=<?php echo $invoice['tid'] ?>" class="aj_delete"><i class="btn-danger btn-sm icon-trash-a"></i> ' + file.name + ' </a></td></tr>');

                    });
                },
                progressall: function(e, data) {
                    var progress = parseInt(data.loaded / data.total * 100, 10);
                    $('#progress .progress-bar').css(
                        'width',
                        progress + '%'
                    );
                }
            }).prop('disabled', !$.support.fileInput)
            .parent().addClass($.support.fileInput ? undefined : 'disabled');
    });

    $(document).on('click', ".aj_delete", function(e) {
        e.preventDefault();

        var aurl = $(this).attr('data-url');
        var obj = $(this);

        jQuery.ajax({

            url: aurl,
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                obj.closest('tr').remove();
                obj.remove();
            }
        });

    });
</script>

<!-- Modal HTML -->
<div id="part_payment" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title"><?php echo $this->lang->line('Payment Confirmation') ?></h4>
            </div>

            <div class="modal-body">
                <form class="payment">
                    <div class="row">
                        <div class="col-xs-6">
                            <div class="input-group">
                                <input type="text" class="form-control" placeholder="مبلغ کل" name="amount" id="rmpay" value="<?php echo number_format($rming, 0, '.', '');  ?>">
                                <div class="input-group-addon"><?php echo $this->config->item('currency') ?></div>
                            </div>

                        </div>
                        <div class="col-xs-6">
                            <div class="input-group">
                                <input type="text" data-jdp="" class="form-control required" id="tsn_date" placeholder="تاریخ واریز" name="paydate" value="<?php $date = $this->jdf->jdate(' Y/m/d');
                                                                                                                                                            echo $date; ?>">
                                <div class="input-group-addon"><span class="icon-calendar4" aria-hidden="true"></span></div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-xs-12 mb-1"><label for="pmethod"><?php echo $this->lang->line('Payment Method') ?></label>
                            <select name="pmethod" class="form-control mb-1">
                                <option value="Cash"><?php echo $this->lang->line('Cash') ?></option>
                                <option value="Card"><?php echo $this->lang->line('Card') ?></option>
                                <option value="Bank"><?php echo $this->lang->line('Bank') ?></option>
                            </select><label for="account"><?php echo $this->lang->line('Account') ?></label>

                            <select name="account" class="form-control">
                                <?php foreach ($acclist as $row) {
                                    echo '<option value="' . $row['id'] . '">' . $row['holder'] . ' / ' . $row['acn'] . '</option>';
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 mb-1"><label for="shortnote"><?php echo $this->lang->line('Note') ?></label>
                            <input type="text" class="form-control" name="shortnote" placeholder="Short note" value="پرداخت برای فاکتور #<?php echo $invoice['tid'] ?>">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <input type="hidden" class="form-control required" name="tid" id="invoiceid" value="<?php echo $invoice['tid'] ?>">
                        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo $this->lang->line('Close') ?></button>
                        <input type="hidden" name="cid" value="<?php echo $invoice['cid'] ?>"><input type="hidden" name="cname" value="<?php echo $invoice['name'] ?>">
                        <button type="button" class="btn btn-primary" id="recpayment"><?php echo $this->lang->line('Make Payment') ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


<!-- cancel -->
<div id="cancel_bill" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title"><?php echo $this->lang->line('Cancel Invoice') ?></h4>
            </div>
            <div class="modal-body">
                <form class="cancelbill">
                    <div class="row">
                        <div class="col-xs-12">
                            You can not revert this action! Are you sure ?

                        </div>
                    </div>


                    <div class="modal-footer">
                        <input type="hidden" class="form-control" name="tid" value="<?php echo $invoice['tid'] ?>">
                        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo $this->lang->line('Close') ?></button>
                        <button type="button" class="btn btn-primary" id="send"><?php echo $this->lang->line('Cancel Invoice') ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
</div>

<<!-- Modal HTML -->
    <div id="sendEmail" class="modal fade">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title">Email</h4>
                </div>
                <div id="request">
                    <div id="ballsWaveG">
                        <div id="ballsWaveG_1" class="ballsWaveG"></div>
                        <div id="ballsWaveG_2" class="ballsWaveG"></div>
                        <div id="ballsWaveG_3" class="ballsWaveG"></div>
                        <div id="ballsWaveG_4" class="ballsWaveG"></div>
                        <div id="ballsWaveG_5" class="ballsWaveG"></div>
                        <div id="ballsWaveG_6" class="ballsWaveG"></div>
                        <div id="ballsWaveG_7" class="ballsWaveG"></div>
                        <div id="ballsWaveG_8" class="ballsWaveG"></div>
                    </div>
                </div>
                <div class="modal-body" id="emailbody" style="display: none;">
                    <form id="sendbill">
                        <div class="row">
                            <div class="col-xs-12">
                                <div class="input-group">
                                    <div class="input-group-addon"><span class="icon-envelope-o" aria-hidden="true"></span></div>
                                    <input type="text" class="form-control" placeholder="Email" name="mailtoc" value="<?php echo $invoice['email'] ?>">
                                </div>

                            </div>

                        </div>


                        <div class="row">
                            <div class="col-xs-12 mb-1"><label for="shortnote"><?php echo $this->lang->line('Customer Name') ?></label>
                                <input type="text" class="form-control" name="customername" value="<?php echo $invoice['name'] ?>">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-12 mb-1"><label for="shortnote"><?php echo $this->lang->line('Subject') ?></label>
                                <input type="text" class="form-control" name="subject" id="subject">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-12 mb-1"><label for="shortnote"><?php echo $this->lang->line('Message') ?></label>
                                <textarea name="text" class="summernote" id="contents" title="Contents"></textarea>
                            </div>
                        </div>

                        <input type="hidden" class="form-control" id="invoiceid" name="tid" value="<?php echo $invoice['tid'] ?>">
                        <input type="hidden" class="form-control" id="emailtype" value="">
                        <input type="hidden" class="form-control" id="itype" value="">


                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo $this->lang->line('Close') ?></button>
                    <button type="button" class="btn btn-primary" id="sendM"><?php echo $this->lang->line('Send') ?></button>
                </div>
            </div>
        </div>
    </div>

    <div id="pop_model" class="modal fade">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title"><?php echo $this->lang->line('Mark As') ?></h4>
                </div>

                <div class="modal-body">
                    <form id="form_model">


                        <div class="row">
                            <div class="col-xs-12 mb-1"><label for="pmethod"><?php echo $this->lang->line('Mark As') ?></label>
                                <select name="status" class="form-control mb-1">
                                    <option value="paid"><?php echo $this->lang->line('Paid') ?></option>
                                    <option value="due"><?php echo $this->lang->line('Due') ?></option>
                                </select>

                            </div>
                        </div>

                        <div class="modal-footer">
                            <input type="hidden" class="form-control required" name="tid" id="invoiceid" value="<?php echo $invoice['tid'] ?>">
                            <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo $this->lang->line('Close') ?></button>
                            <input type="hidden" id="action-url" value="rec_invoices/update_status">
                            <button type="button" class="btn btn-primary" id="submit_model"><?php echo $this->lang->line('Change Status') ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div id="pop_model2" class="modal fade">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title"><?php echo $this->lang->line('Recurring') ?></h4>
                </div>

                <div class="modal-body">
                    <form id="form_model2">


                        <div class="row">
                            <div class="col-xs-12 mb-1"><label for="pmethod"><?php echo $this->lang->line('Mark As') ?></label>
                                <select name="status" class="form-control mb-1">
                                    <option value="Recurring"><?php echo $this->lang->line('(On) Recurring') ?></option>
                                    <option value="Stopped"><?php echo $this->lang->line('(Off) Stop') ?></option>
                                </select>

                            </div>
                        </div>

                        <div class="modal-footer">
                            <input type="hidden" class="form-control required" name="tid" id="invoiceid" value="<?php echo $invoice['tid'] ?>">
                            <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo $this->lang->line('Close') ?></button>
                            <input type="hidden" id="action-url" value="rec_invoices/rec_status">
                            <button type="button" class="btn btn-primary" id="submit_model2"><?php echo $this->lang->line('Change Status') ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!--sms-->
    <!-- Modal HTML -->
    <div id="sendSMS" class="modal fade">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title"><?php echo $this->lang->line('Send'); ?> SMS</h4>
                </div>
                <div id="request_sms">
                    <div id="ballsWaveG1">
                        <div id="ballsWaveG_1" class="ballsWaveG"></div>
                        <div id="ballsWaveG_2" class="ballsWaveG"></div>
                        <div id="ballsWaveG_3" class="ballsWaveG"></div>
                        <div id="ballsWaveG_4" class="ballsWaveG"></div>
                        <div id="ballsWaveG_5" class="ballsWaveG"></div>
                        <div id="ballsWaveG_6" class="ballsWaveG"></div>
                        <div id="ballsWaveG_7" class="ballsWaveG"></div>
                        <div id="ballsWaveG_8" class="ballsWaveG"></div>
                    </div>
                </div>
                <div class="modal-body" id="smsbody" style="display: none;">
                    <form id="sendsms">
                        <div class="row">
                            <div class="col-xs-12">
                                <div class="input-group">
                                    <div class="input-group-addon"><span class="icon-envelope-o" aria-hidden="true"></span></div>
                                    <input type="text" class="form-control" placeholder="SMS" name="mobile" value="<?php echo $invoice['phone'] ?>">
                                </div>

                            </div>

                        </div>


                        <div class="row">
                            <div class="col-xs-12 mb-1"><label for="shortnote"><?php echo $this->lang->line('Customer Name'); ?></label>
                                <input type="text" class="form-control" value="<?php echo $invoice['name'] ?>">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-xs-12 mb-1"><label for="shortnote"><?php echo $this->lang->line('Message'); ?></label>
                                <textarea class="form-control" name="text_message" id="sms_tem" title="Contents" rows="3"></textarea>
                            </div>
                        </div>


                        <input type="hidden" class="form-control" id="smstype" value="">


                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo $this->lang->line('Close'); ?></button>
                    <button type="button" class="btn btn-primary" id="submitSMS"><?php echo $this->lang->line('Send'); ?></button>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        $(function() {
            $('.summernote').summernote({
                height: 100,
                toolbar: [
                    // [groupName, [list of button]]
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['font', ['strikethrough', 'superscript', 'subscript']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['height', ['height']],
                    ['fullscreen', ['fullscreen']],
                    ['codeview', ['codeview']]
                ]
            });

            $('#sendM').on('click', function(e) {
                e.preventDefault();

                sendBill($('.summernote').summernote('code'));

            });
        });

        $(document).on('click', "#cancel-bill_rec", function(e) {
            e.preventDefault();

            $('#cancel_bill').modal({
                backdrop: 'static',
                keyboard: false
            }).one('click', '#send', function() {
                var acturl = 'transactions/cancelrec';
                cancelBill(acturl);

            });
        });
    </script>