<div class="app-content content container-fluid">
    <div class="content-wrapper">
        <div class="content-header">
            <div class="card-header">
                <h4 class="card-title"><?php echo $this->lang->line('Company Statistics') ?><a class="float-xs-right" href="<?php echo base_url() ?>reports/refresh_data"><i class="icon-refresh2"></i></a></h4>


            </div>
        </div>
        <div class="content-body">
            <!-- stats -->

            <!--/ stats -->
            <!--/ project charts -->
            <div class="row">
                <div class="col-xl-12 col-lg-12">
                    <div class="card">
                        <div class="card-header no-border">
                            <h6 class="card-title"><?php echo $this->lang->line('Sales in last 12 months') ?></h6>

                        </div>

                        <div class="card-body">


                            <div id="invoices-sales-chart"></div>

                        </div>

                    </div>
                </div>

            </div>
            <div class="row">
                <div class="col-xl-12 col-lg-12">
                    <div class="card">
                        <div class="card-header no-border">
                            <h6 class="card-title"><?php echo $this->lang->line('Products in last 12 months') ?></h6>

                        </div>

                        <div class="card-body">


                            <div id="invoices-products-chart"></div>

                        </div>

                    </div>
                </div>

            </div>
            <!--/ project charts -->
            <!-- Recent invoice with Statistics -->
            <div class="row match-height">

                <div class="col-xl-12 col-lg-12 ">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title"><?php echo $this->lang->line('All Time Detailed Statistics') ?></h4>
                            <a class="heading-elements-toggle"><i class="icon-ellipsis font-medium-3"></i></a>
                            <div class="heading-elements">
                                <ul class="list-inline mb-0">
                                    <li><a data-action="reload"><i class="icon-reload"></i></a></li>
                                    <li><a data-action="expand"><i class="icon-expand2"></i></a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="card-body">

                            <div class="table-responsive">
                                <table class="table table-hover mb-1">
                                    <thead>
                                        <tr>
                                            <th><?php echo $this->lang->line('Month') ?></th>
                                            <th><?php echo $this->lang->line('Income') ?></th>
                                            <th><?php echo $this->lang->line('Expenses') ?></th>
                                            <th><?php echo $this->lang->line('Sales') ?></th>
                                            <th><?php echo $this->lang->line('Invoices') ?></th>
                                            <th><?php echo $this->lang->line('sold') . $this->lang->line('products') ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php

                                        foreach ($stat as $item) {
                                            // $month=date("F", $item['month']);
                                            $date = $this->jdf->s_gregorian_to_jalali($item['year'] . '-' . $item['month'] . '-' . '15');
                                            $date_explode = explode('/', $date);
                                            echo '<tr>
                                <td class="text-truncate">' . $date_explode[1] . ', ' . $date_explode[0] . '</td>
                                <td class="text-truncate"> ' . $item['income'] . '</td>
                            
                                <td class="text-truncate">' . $item['expense'] . '</td>
                                 <td class="text-truncate">' . $item['sales'] . '</td>
                                  <td class="text-truncate">' . $item['invoices'] . '</td>
                                   <td class="text-truncate">' . $item['items'] . '</td>
                               
                            </tr>';
                                        } ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Recent invoice with Statistics -->
        </div>
    </div>
</div>
<script type="text/javascript">
    function gregorian_to_jalali(gy, gm, gd) {
        var g_d_m, jy, jm, jd, gy2, days;
        g_d_m = [0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334];
        gy2 = (gm > 2) ? (gy + 1) : gy;
        days = 355666 + (365 * gy) + ~~((gy2 + 3) / 4) - ~~((gy2 + 99) / 100) + ~~((gy2 + 399) / 400) + gd + g_d_m[gm - 1];
        jy = -1595 + (33 * ~~(days / 12053));
        days %= 12053;
        jy += 4 * ~~(days / 1461);
        days %= 1461;
        if (days > 365) {
            jy += ~~((days - 1) / 365);
            days = (days - 1) % 365;
        }
        if (days < 186) {
            jm = 1 + ~~(days / 31);
            jd = 1 + (days % 31);
        } else {
            jm = 7 + ~~((days - 186) / 30);
            jd = 1 + ((days - 186) % 30);
        }
        return [jy, jm, jd];
    }
    $('#invoices-sales-chart').empty();

    Morris.Bar({
        element: 'invoices-sales-chart',
        data: [
            <?php $i = 0;
            foreach (array_reverse($stat) as $row) {
                if ($i > 11) exit;
                $year = $row['year'];
                $month = $row['month'];
                $num = cal_days_in_month(CAL_GREGORIAN, $row['month'], $row['year']);
                $date = $this->jdf->s_gregorian_to_jalali($year . '-' . $month . '-' . $num);
                $explode = explode('/', $date);
                $day_month = $this->jdf->get_jMonth_to_gday($explode[1]);
                $date_end = $explode[0] . '-' . $explode[1] . '-' . $day_month;
                echo "{ x: '" . $date_end . "', y: " . intval($row['income']) . ", z: " . intval($row['expense']) . "},";
                $i++;
            } ?>
        ],
        xkey: 'x',
        ykeys: ['y', 'z'],
        labels: ['درآمد', 'هزینه'],
        xLabels: "month",
        hideHover: 'auto',
        resize: true,
        barColors: ['#34cea7', '#ff6e40'],
    });
    $('#invoices-products-chart').empty();

    Morris.Line({
        element: 'invoices-products-chart',
        data: [
            <?php $i = 0;
            foreach (array_reverse($stat) as $row) {
                if ($i > 11) exit;
                $num = cal_days_in_month(CAL_GREGORIAN, $row['month'], $row['year']);
                echo "{ x: '" . $row['year'] . '-' . sprintf("%02d", $row['month']) . "-$num', y: " . intval($row['items']) . ", z: " . intval($row['invoices']) . "},";
                $i++;
            } ?>
        ],
        xkey: 'x',
        ykeys: ['y', 'z'],
        labels: ['محصولات', 'فاکتورها'],
        hideHover: 'auto',
        resize: true,
        xLabelFormat: function(x) {
            g_y = x.getFullYear();
            g_m = x.getMonth() + 1;
            g_d = x.getDate();
            shamsi = gregorian_to_jalali(g_y, g_m, g_d);
            return (shamsi[0] + '/' + shamsi[1] + '/' + shamsi[2]);
        },
        hoverCallback: function(index, options, content) {
            const html_content = $.parseHTML(content);
            const dates = html_content[0].innerHTML.split("-");
            html_content[0].innerHTML = gregorian_to_jalali(parseInt(+dates[0]), +dates[1], +dates[2]);
            var strContent = "";
            for (var i = 0; i < html_content.length; i++) {
                strContent += html_content[i].outerHTML;
            }
            return (strContent);
        },
        lineColors: ['#34cea7', '#ff6e40'],
    });
</script>