<div class="app-content content container-fluid">
    <div class="content-wrapper">


        <div class="content-body">
            <section class="card">
                <div id="invoice-template" class="card-block">
                    <div class="row wrapper white-bg page-heading">

                        <div class="col-lg-12">
                            <?php
                            $validtoken = hash_hmac('ripemd160', 'rec' . $invoice['tid'], $this->config->item('encryption_key'));

                            $link = '../../billing/invoice?id=' . $invoice['tid'] . '&token=' . $validtoken;
                            $linkp = '../../billing/print_rec?id=' . $invoice['tid'] . '&token=' . $validtoken;
                            if ($invoice['status'] != 'canceled') { ?>
                                <div class="title-action">




                                    <a href="<?php echo $linkp; ?>" class="btn btn-success"><i class="icon-print"></i> <?php echo $this->lang->line('Print') ?></a>
                                    <a href="<?php echo $link; ?>" class="btn btn-primary"><i class="icon-money"></i> <?php echo $this->lang->line('Make Payment') ?></a>





                                </div><?php } else {
                                        echo '<h2 class="btn btn-oval btn-danger">' . $this->lang->line('Cancelled') . '</h2>';
                                    } ?>
                        </div>
                    </div>
                    <br>
                    <br>
                    <br>

                    <div class="row">
                        <div class="col-sm-6 top-left">
                            <img src=" ../../userfiles/company/<?php echo $this->config->item('logo') ?>" class="img-responsive p-1 m-b-2" style="max-height: 120px;">
                        </div>
                        <div class="col-sm-6 top-right" style="text-align: center;">
                            <p class="marginright lead"> <?php echo  $this->lang->line('RECCURING INVOICE') . ':' . prefix(3) . ' #' . $invoice['tid']  ?></p>
                            <p class="marginright lead"><?php echo  $this->lang->line('Due Date') . ': ' . $this->jdf->s_gregorian_to_jalali(dateformat($invoice['invoiceduedate']))   ?> </p>
                            <p class="marginright lead"><?php echo  $this->lang->line('Payment Status') . ': ' . $this->lang->line(ucwords($invoice['status'])) ?> </p>
                        </div>

                    </div>
                    <hr>
                    <div class="row">
                        <!-- Invoice Items Details -->
                        <div class="col-xs-4 text-right payment-details">
                            <p class="lead marginbottom payment-info">جزئیات پرداخت</p>
                            <p><?php echo $this->lang->line('Reference') . ':' . $invoice['refer']; ?></p>
                            <p><?php echo $this->lang->line('Invoice Date') . ':' . $this->jdf->s_gregorian_to_jalali(dateformat($invoice['invoicedate'])); ?></p>
                            <p><?php echo  $this->lang->line('Gross Amount') . ':' . amountExchange($invoice['total'], $invoice['multi']); ?> </p>
                            <p><?php echo $this->lang->line('Reccur after') . ':' .  $this->lang->line(ucwords($invoice['rec'])); ?> </p>
                            <p></p>
                        </div>
                        <!--/ Invoice Items Details -->


                        <!-- Invoice Customer Details -->
                        <div class="col-xs-4 to">
                            <p class="lead marginbottom"><?php echo $this->lang->line('Bill To')   . ' :' . $invoice['name']; ?></p>
                            <?php echo '<p>' . $invoice['country'] . ' ' . $invoice['city']  . ' ' .
                                $invoice['address'] . ' </p><p>' . $this->lang->line('Phone') . ': ' .  $invoice['phone'] . ' </p>' . $this->lang->line('Email') . ' : ' . $invoice['email'] . '</p>'; ?>
                            </p>
                        </div>
                        <!-- / Invoice Customer Details -->

                        <!-- Invoice Company Details -->
                        <div class="col-xs-4 to">
                            <p class="lead marginbottom"><?php echo $this->lang->line('From') . ' :' . $this->config->item('ctitle'); ?></p>

                            <?php echo '<p>' . $this->config->item('city') . ': ' .  $this->config->item('address') . ' </p><p>' . $this->lang->line('Phone')  . ': ' . $this->config->item('phone')  . ' </p>' . $this->lang->line('Email') . ' : ' .  $this->config->item('email') . '</p>'; ?>
                            </p>
                        </div>
                        <!-- / Invoice Company Details -->
                    </div>
                </div>
                <!-- End new section -->



                <!-- Invoice Items Details -->
                <div id="invoice-items-details" class="pt-2">
                    <div class="row">
                        <div class="table-responsive col-sm-12">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo $this->lang->line('Description') ?></th>
                                        <th class="text-xs-left"><?php echo $this->lang->line('Rate') ?></th>
                                        <th class="text-xs-left"><?php echo $this->lang->line('Qty') ?></th>
                                        <th class="text-xs-left"><?php echo $this->lang->line('Tax') ?></th>
                                        <th class="text-xs-left"><?php echo $this->lang->line('Discount') ?></th>
                                        <th class="text-xs-left"><?php echo $this->lang->line('Amount') ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $c = 1;
                                    foreach ($products as $row) {

                                        echo '<tr>
<th scope="row">' . $c . '</th>
                            <td>' . $row['product'] . '</td>
                           
                            <td>' . amountExchange($row['price'], $invoice['multi']) . '</td>
                             <td>' . $row['qty'] . '</td>
                            <td>' . amountExchange($row['totaltax'], $invoice['multi']) . ' (' . amountFormat_s($row['tax']) . '%)</td>
                            <td>' . amountExchange($row['totaldiscount'], $invoice['multi']) . ' (' . amountFormat_s($row['discount']) . '' . $invoice['format_discount'] . ')</td>
                            <td>' . amountExchange($row['subtotal'], $invoice['multi']) . '</td>
                        </tr>';
                                        echo '<tr><td colspan=5>' . $row['product_des'] . '</td></tr>';
                                        $c++;
                                    } ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                    <p></p>
                    <div class="row">
                        <div class="col-md-7 col-sm-12 text-xs-center text-md-left">


                            <div class="row">
                                <div class="col-md-8">
                                    <p class="lead"><?php echo $this->lang->line('Payment Status') ?>:
                                        <u><strong id="pstatus"><?php echo $this->lang->line(ucwords($invoice['status'])) ?></strong></u>
                                    </p>
                                    <p class="lead"><?php echo $this->lang->line('Invoice Status') ?>: <u><strong id="pstatus"><?php echo $this->lang->line(strtoupper($invoice['ron']));  ?></strong></u>
                                    </p>
                                    <p class="lead"><?php echo $this->lang->line('Payment Method') ?>: <u><strong id="pmethod"><?php echo $this->lang->line($invoice['pmethod']) ?></strong></u>
                                    </p>

                                    <p class="lead mt-1"><br><?php echo $this->lang->line('Note') ?>:</p>
                                    <code>
                                        <?php echo $invoice['notes'] ?>
                                    </code>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5 col-sm-12">
                            <p class="lead"><?php echo $this->lang->line('Total Due') ?></p>
                            <div class="table-responsive">
                                <table class="table">
                                    <tbody>
                                        <tr>
                                            <td><?php echo $this->lang->line('Sub Total') ?></td>
                                            <td class="text-xs-right"> <?php echo amountExchange($invoice['subtotal'], $invoice['multi']) ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo $this->lang->line('TAX') ?></td>
                                            <td class="text-xs-right"><?php echo amountExchange($invoice['tax'], $invoice['multi']) ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo $this->lang->line('Shipping') ?></td>
                                            <td class="text-xs-right"><?php echo amountExchange($invoice['shipping'], $invoice['multi']) ?></td>
                                        </tr>
                                        <tr>
                                            <td class="text-bold-800"><?php echo $this->lang->line('Total') ?></td>
                                            <td class="text-bold-800 text-xs-right"> <?php echo amountExchange($invoice['total'], $invoice['multi']) ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo $this->lang->line('Payment Made') ?></td>
                                            <td class="pink text-xs-right">
                                                (-) <?php echo ' <span id="paymade">' . amountExchange($invoice['pamnt'], $invoice['multi']) ?></span></td>
                                        </tr>
                                        <tr class="bg-grey bg-lighten-4">
                                            <td class="text-bold-800"><?php echo $this->lang->line('Balance Due') ?></td>
                                            <td class="text-bold-800 text-xs-right"> <?php $myp = '';
                                                                                        $rming = $invoice['total'] - $invoice['pamnt'];
                                                                                        if ($rming < 0) {
                                                                                            $rming = 0;
                                                                                        }
                                                                                        echo ' <span id="paydue">' . amountExchange($rming, $invoice['multi']) . '</span></strong>'; ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="text-xs-center">
                                <p><?php echo $this->lang->line('Authorized person') ?></p>
                                <?php echo '<img src="../../userfiles/employee_sign/' . $employee['sign'] . '" alt="signature" class="height-100"/>
                                    <h6>(' . $employee['name'] . ')</h6>
                                    <p class="text-muted">' . user_role($employee['roleid']) . '</p>'; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Invoice Footer -->

                <div id="invoice-footer">
                    <p class="lead"><?php echo $this->lang->line('Credit Transactions') ?>:</p>
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th><?php echo $this->lang->line('Date') ?></th>
                                <th><?php echo $this->lang->line('Method') ?></th>
                                <th><?php echo $this->lang->line('Amount') ?></th>
                                <th><?php echo $this->lang->line('Note') ?></th>


                            </tr>
                        </thead>
                        <tbody id="activity">
                            <?php foreach ($activity as $row) {

                                echo '<tr>
                            <td>' . $this->jdf->s_gregorian_to_jalali($row['date']) . '</td>
                            <td>' . $this->lang->line($row['method']) . '</td>
                            <td>' . amountExchange($row['credit'], $invoice['multi']) . '</td>
                            <td>' . $row['note'] . '</td>
                        </tr>';
                            } ?>

                        </tbody>
                    </table>

                    <div class="row">

                        <div class="col-md-7 col-sm-12">

                            <h6><?php echo $this->lang->line('Terms & Condition') ?></h6>
                            <p> <?php

                                echo '<strong>' . $invoice['termtit'] . '</strong><br>' . $invoice['terms'];
                                ?></p>
                        </div>

                    </div>

                </div>
                <!--/ Invoice Footer -->

        </div>
        </section>
    </div>
</div>
</div>