<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=Edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <title>NeoBilling Installation</title>
    <link rel='stylesheet' type='text/css' href='assets/css/bootstrap.css' />
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">

    <link rel='stylesheet' type='text/css' href='assets/css/install.css' />
    <link rel="shortcut icon" href="../assets/images/favicon.ico" />

    <script type='text/javascript' src='assets/js/jquery.min.js'></script>
    <script type='text/javascript' src='assets/jquery-validation/jquery.validate.min.js'></script>
    <script type='text/javascript' src='assets/jquery-validation/jquery.form.js'></script>

</head>

<body>
    <div class="install-box">

        <div class="panel panel-install">
            <div class="panel-heading text-center">
                <h2>نصب کننده اسکریپت نئوبیلینگ</h2>
            </div>
            <div class="panel-body no-padding">
                <div class="tab-container clearfix">
                    <div id="terms" class="tab-title col-sm-3 active"><i class="fa fa-circle-o"></i><strong>
                            درباره اسکریپت</strong></span></div>
                    <div id="pre-installation" class="tab-title col-sm-3"><i class="fa fa-circle-o"></i><strong>
                            پیش نیازهای قبل از نصب</strong></span></div>
                    <div id="configuration" class="tab-title col-sm-3"><i class="fa fa-circle-o"></i><strong>
                            پیکربندی</strong></div>
                    <div id="finished" class="tab-title col-sm-3"><i class="fa fa-circle-o"></i><strong> پایان نصب</strong>
                    </div>
                </div>
                <div class="tab-content">
                    <div role="tabpanel" class="tab-pane active" id="terms-tab">
                        <div class="section">
                            <div class="text-center">
                                <h4>درباره</h4>
                                <hr class="star-primary">
                                <p>نام اپلیکیشن: <strong>نئو بیلینگ</strong></p>
                                <p>نسخه: <strong> v <?php echo VER ?></strong></p>

                                <p>ترجمه و توسعه داده شده توسط: <strong>نارین وب</strong> [ <a href="https://www.rtl-theme.com/author/samanrabiei/" target="_blank">پروفایل در راستچین</a>
                                    ]</p>
                            </div>
                        </div>
                        <div class="section">
                            <div class="text-center">
                                <h4>پشتیبانی</h4>
                                <hr class="star-primary">
                                <p><strong><strong class="text-danger">یاداشت</strong>: لطفا به این نکته توجه داشته باشید
                                    </strong></p>
                                <p>در صورت مواجه شدن با هر مشکلی آن را تنها از طریق تیکت راست چین به ما اعلام نمایید تا بررسی و حل شود.<br>
                                    <a href="https://www.rtl-theme.com/" target="_blank">بخش پشتیبانی</a>
                                </p>
                            </div>
                        </div>


                        <div class="panel-footer">
                            <button class="btn btn-info form-next1"><i class='fa fa-chevron-right'></i> بعدی</button>
                        </div>

                    </div>


                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane" id="pre-installation-tab">
                            <div class="section">
                                <p><strong>لطفاً تنظیمات PHP سرور را برای مطابقت با شرایط زیر پیکربندی کنید:</strong></p>
                                <hr />
                                <div>
                                    <table>
                                        <thead>
                                            <tr>
                                                <th width="25%">PHP تنظیمات</th>
                                                <th width="27%">نسخه فعلی</th>
                                                <th>نسخه لازم</th>
                                                <th class="text-center">وضعیت</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>PHP Version</td>
                                                <td><?php echo $current_php_version; ?></td>
                                                <td><?php echo $php_version_required; ?>+</td>
                                                <td class="text-center">
                                                    <?php if ($php_version_success) {
                                                        $all_requirement_success = true;
                                                    ?>
                                                        <i class="status fa fa-check-circle-o"></i>
                                                    <?php } else {
                                                        $all_requirement_success = false;
                                                    ?>
                                                        <i class="status fa fa-times-circle-o"></i>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <div class="section">
                                <p><strong>لطفا مطمئن شوید که افزونه ها (extensions) و تنظیمات لیست شده در زیر
                                        نصب یا فعال هستند:</strong></p>
                                <hr />
                                <div>
                                    <table>
                                        <thead>
                                            <tr>
                                                <th width="25%">تنظیمات</th>
                                                <th width="27%">تنظیمات فعلی</th>
                                                <th>تنظیمات لازم</th>
                                                <th class="text-center">وضعیت</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>MySQLi</td>
                                                <td> <?php if ($mysql_success) {
                                                            $all_requirement_success = true; ?>
                                                        On
                                                    <?php } else {
                                                            $all_requirement_success = true; ?>
                                                        Off
                                                    <?php } ?>
                                                </td>
                                                <td>On</td>
                                                <td class="text-center">
                                                    <?php if ($mysql_success) {
                                                        $all_requirement_success = true; ?>
                                                        <i class="status fa fa-check-circle-o"></i>
                                                    <?php } else {
                                                        $all_requirement_success = false; ?>
                                                        <i class="status fa fa-times-circle-o"></i>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>GD</td>
                                                <td> <?php if ($gd_success) {
                                                            $all_requirement_success = true; ?>
                                                        On
                                                    <?php } else { ?>
                                                        Off
                                                    <?php } ?>
                                                </td>
                                                <td>On</td>
                                                <td class="text-center">
                                                    <?php if ($gd_success) {
                                                        $all_requirement_success = true; ?>
                                                        <i class="status fa fa-check-circle-o"></i>
                                                    <?php } else {
                                                        $all_requirement_success = false; ?>
                                                        <i class="status fa fa-times-circle-o"></i>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>cURL</td>
                                                <td> <?php if ($curl_success) {
                                                            $all_requirement_success = true; ?>
                                                        On
                                                    <?php } else {
                                                            $all_requirement_success = false; ?>
                                                        Off
                                                    <?php } ?>
                                                </td>
                                                <td>On</td>
                                                <td class="text-center">
                                                    <?php if ($curl_success) {
                                                        $all_requirement_success = true; ?>
                                                        <i class="status fa fa-check-circle-o"></i>
                                                    <?php } else { ?>
                                                        <i class="status fa fa-times-circle-o"></i>
                                                    <?php } ?>
                                                </td>
                                            </tr>

                                            <tr>
                                                <td>mbstring</td>
                                                <td> <?php if ($mbstring) { ?>
                                                        On
                                                    <?php } else {
                                                            $all_requirement_success = false; ?>
                                                        Off
                                                    <?php } ?>
                                                </td>
                                                <td>On</td>
                                                <td class="text-center">
                                                    <?php if ($mbstring) {
                                                        $all_requirement_success = true; ?>
                                                        <i class="status fa fa-check-circle-o"></i>
                                                    <?php } else {
                                                        $all_requirement_success = false; ?>
                                                        <i class="status fa fa-times-circle-o"></i>
                                                    <?php } ?>
                                                </td>
                                            </tr>


                                            <tr>
                                                <td>date.timezone</td>
                                                <td> <?php if ($timezone_success) {
                                                            echo $timezone_settings;
                                                        } else {
                                                            echo "Null";
                                                        } ?>
                                                </td>
                                                <td>Timezone</td>
                                                <td class="text-center">
                                                    <?php if ($timezone_success) { ?>
                                                        <i class="status fa fa-check-circle-o"></i>
                                                    <?php } else { ?>
                                                        <i class="status fa fa-times-circle-o"></i>
                                                    <?php } ?>
                                                </td>
                                            </tr>

                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <div class="section">
                                <p><strong>لطفا مطمئن شوید فایل های زیر مجوز <code>writable</code> را داشته باشند:</strong></p>
                                <hr />
                                <div>
                                    <table>
                                        <tbody>
                                            <?php
                                            $all_files_success = true;
                                            foreach ($writeable_directories as $value) {
                                            ?>
                                                <?php if (!is_writeable('..' . $value)) { ?>
                                                    <tr>
                                                        <td style="width:87%;"><?php echo $value; ?></td>
                                                        <td class="text-center">
                                                            <?php
                                                            $all_files_success = false;
                                                            ?>
                                                            <i class="status fa fa-times-circle-o"></i>
                                                            <?php ?>
                                                        </td>
                                                    </tr>
                                                <?php }
                                            }
                                            if (!file_exists('../.htaccess')) {

                                                echo '<tr>
                                                <td style="width:87%;">';

                                                echo '<div class="alert alert-warning ">You missed <strong>.htaccess</strong> file! Upload from <strong>application_setup</strong> folder. On some file managers it may hidden. You can find the settings option to show hidden files in File Manager by going to the top right corner and clicking on the gear icon. If you ignore this alert , you may receive <strong>404 Page Not Found error</strong> after the installation.</div>';

                                                echo '</td>
                                                <td class="text-center">';



                                                echo '<i class="status fa fa-times-circle-o"></i>
                                                    
                                                </td>
                                            </tr>';
                                            }

                                            echo '</tbody>
                                    </table>';
                                            /*<tr>
                                                <td style="width:87%;"> echo 'You missed <strong>.htaccess</strong> file! Upload from <strong>application_setup</strong> folder'; </td>
                                                <td class="text-center">
                                                    
                                                    //$all_files_success = false;
                                                   
                                                    <i class="status fa fa-times-circle-o"></i>
                                                     ?>
                                                </td>
                                            </tr>
											*/
                                            if ($all_files_success) { ?>
                                                <hr>
                                                <div class="alert alert-success">تمامی فایل و پوشه ها مجوز writable را دارند.</div>
                                            <?php } else {
                                                $all_requirement_success = false;

                                            ?>

                                                <hr>
                                                <div class="alert alert-danger">فایل ها و پوشه های مورد نیاز مجوز writable را ندارند.</div>

                                            <?php
                                            }
                                            ?>

                                </div>
                            </div>

                            <div class="panel-footer">
                                <button <?php
                                        if (!$all_requirement_success) {
                                            echo "disabled=disabled";
                                        }
                                        ?> class="btn btn-info form-next"><i class='fa fa-chevron-right'></i> بعدی
                                </button>
                            </div>

                        </div>
                        <div role="tabpanel" class="tab-pane" id="configuration-tab">
                            <form name="config-form" id="config-form" action="action.php" method="post">

                                <div class="section clearfix">
                                    <p><strong> لطفا جزئیات اتصال به دیتابیس خود را وارد کنید.</strong></p>
                                    <hr />
                                    <div>
                                        <div class="form-group clearfix">
                                            <label for="host" class=" col-md-3">هاست دیتابیس</label>
                                            <div class="col-md-9">
                                                <input type="text" value="" id="host" name="host" class="form-control" placeholder="هاست دیتابیس(معمولا همان localhost است)" />
                                            </div>
                                        </div>
                                        <div class="form-group clearfix">
                                            <label for="dbname" class=" col-md-3">نام دیتابیس</label>
                                            <div class=" col-md-9">
                                                <input type="text" value="" name="dbname" class="form-control" placeholder="نام دیتابیس" />
                                            </div>
                                        </div>
                                        <div class="form-group clearfix">
                                            <label for="dbuser" class=" col-md-3">کاربر دیتابیس</label>
                                            <div class=" col-md-9">
                                                <input type="text" value="" name="dbuser" class="form-control" autocomplete="off" placeholder="نام کاربر دیتابیس" />
                                            </div>
                                        </div>
                                        <div class="form-group clearfix">
                                            <label for="dbpassword" class=" col-md-3">رمز عبور</label>
                                            <div class=" col-md-9">
                                                <input type="password" value="" name="dbpassword" class="form-control" autocomplete="off" placeholder="رمزی که برای کاربر دیتابیس انتخاب کرده اید" />
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="section clearfix">
                                    <p><strong> لطفا جزئیات کاربر ادمین برای ورود به سیستم پس از نصب را وارد نمایید.</strong></p>
                                    <hr />
                                    <div>

                                        <div class="form-group clearfix">
                                            <label for="email" class=" col-md-3">اپلیکیشن URL</label>
                                            <div class=" col-md-9">
                                                <?php
                                                $http = (@$_SERVER["HTTPS"] == "on") ? "https://" : "http://";
                                                $cururl = $http . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
                                                $appurl = str_replace('/install/', '', $cururl);
                                                $appurl = str_replace('index.php', '', $appurl);

                                                echo '<input type="text" value="' . $appurl . '" name="app_url[]" class="form-control" placeholder="app access url" readonly="" />';

                                                ?>
                                            </div>
                                        </div>


                                        <div class="form-group clearfix">
                                            <label for="host" class=" col-md-3">ایمیل ورود</label>
                                            <div class="col-md-9">
                                                <input type="email" name="email" class="form-control" placeholder="Email" />
                                            </div>
                                        </div>

                                        <div class="form-group clearfix">
                                            <label for="host" class=" col-md-3"> رمز عبور ورود</label>
                                            <div class="col-md-9">
                                                <input type="text" name="password" class="form-control" placeholder="Password" value="123456" readonly="">
                                                <small>پس از نصب اسکریپت لطفا از بخش کارمندان، یک کاربر با سطح "صاحب کسب و کار " ایجاد نمایید و پس از وارد شدن در حساب این حساب کاربری را حذف نمایید.</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="section clearfix">

                                </div>

                                <div class="panel-footer">
                                    <button type="submit" class="btn btn-info form-next">
                                        <span class="loader hide"> لطفا کمی صبر کنید...این عملیات ممکن است 5+ دقیقه طول بکشد...</span>
                                        <span class="button-text"><i class='fa fa-chevron-right'></i> اتمام</span>
                                    </button>
                                </div>

                            </form>
                        </div>

                        <div role="tabpanel" class="tab-pane" id="finished-tab">
                            <div class="section">
                                <div class="clearfix">
                                    <i class="status fa fa-check-circle-o pull-left" style="font-size: 50px"> </i><span class="pull-left" style="line-height: 50px;">تبریک می گوییم، اسکریپت نئو بیلینگ با موفقیت نصب شد.</span>

                                </div>

                                <div style="margin: 15px 0 15px 60px; color: #d73b3b;">
                                    توجه نمایید که پس از نصب حتما پوشه install .را حذف نمایید
                                </div>
                                <div style="margin: 15px 0 15px 60px;">
                                    <strong><strong class="text-danger">یاداشت</strong>: پشتیبانی محصول فقط از طریق تیکت راست چین و تنها برای خریداران صورت می گیرد.</strong>
                                </div>

                                <div style="margin: 15px 0 15px 60px; font-size: 16px">
                                    <p>
                                        نام کاربری و رمز عبور ورود مواردی هستند که در مرحله قبل وارد کردید.

                                    </p>
                                </div>
                                <a class="go-to-login-page" href="<?php echo $appurl; ?>">
                                    <div class="text-center">
                                        <div style="font-size: 100px;"><i class="fa fa-desktop"></i></div>
                                        <div>رفتن به صفحه ورود</div>
                                    </div>
                                </a>
                            </div>

                        </div>
                        <div id="alert-container">

                        </div>
                        <div class="text-center m-b-10">
                            نسخه اورجینال و اصلی اسکریپت تنها در راست چین <a href="https://www.rtl-theme.com/neo-billing-script/" target="_blank">قابل خرید است</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
</body>

</html>

<script type="text/javascript">
    var configurationIab = $('#form_control');
    var onFormSubmit = function($form) {
        configurationIab.attr('name', 'app_url[]');
        $form.find('[type="submit"]').attr('disabled', 'disabled').find(".loader").removeClass("hide");
        $form.find('[type="submit"]').find(".button-text").addClass("hide");
        $("#alert-container").html("");
    };
    var onSubmitSussess = function($form) {
        $form.find('[type="submit"]').removeAttr('disabled').find(".loader").addClass("hide");
        $form.find('[type="submit"]').find(".button-text").removeClass("hide");
    };


    $(document).ready(function() {
        var $preInstallationTab = $("#pre-installation-tab"),
            $termTab = $("#terms-tab"),
            $configurationTab = $("#configuration-tab");


        $(".form-next1").click(function() {

            $termTab.removeClass("active");
            $("#terms").removeClass("active");
            $preInstallationTab.addClass("active");
            $("#pre-installation").addClass("active");
            $("#terms").find("i").removeClass("fa-circle-o").addClass("fa-check-circle");

        });
        $(".form-next").click(function() {

            if ($preInstallationTab.hasClass("active")) {
                $("#pre-installation").removeClass("active");
                $preInstallationTab.removeClass("active");

                $termTab.removeClass("active");
                $configurationTab.addClass("active");
                $("#pre-installation").find("i").removeClass("fa-circle-o").addClass("fa-check-circle");
                $("#configuration").addClass("active");
                $("#host").focus();
            }
        });

        $("#config-form").submit(function() {
            var $form = $(this);
            onFormSubmit($form);
            $form.ajaxSubmit({
                dataType: "json",
                success: function(result) {
                    onSubmitSussess($form, result);
                    if (result.success) {
                        $configurationTab.removeClass("active");
                        $("#configuration").find("i").removeClass("fa-circle-o").addClass("fa-check-circle");
                        $("#finished").find("i").removeClass("fa-circle-o").addClass("fa-check-circle");
                        $("#finished").addClass("active");
                        $("#finished-tab").addClass("active");
                    } else {
                        $("#alert-container").html('<div class="alert alert-danger" role="alert">' + result.message + '</div>');
                    }
                }
            });
            return false;
        });

    });
</script>